<?php

namespace data;

/**
 * Рецепт [recipe]
 * @property int profession_id
 * @property int item_id
 * @property int item_count
 *
 * @property int exp
 * @property int life
 * @property int level
 * @property int doodad_id
 * @property int energy
 * @property int money
 * @property string title
 * @property string icon
 */
class Recipe extends \Data
{
    protected $profession_id = 0;
    protected $item_id = 0;
    protected $item_count = 1;
    protected $money = 0;
    protected $exp = 0;
    protected $life = 0;
    protected $level = 1;
    protected $energy = 0;
    protected $doodad_id = 0;
    protected $title;
    protected $icon;

    protected $required_items = [];
    protected $result_items = [];

    /**
     * @return array
     */
    public function getRequiredItems()
    {
        if (!$this->required_items) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare('SELECT * FROM `recipe_required_items` WHERE `recipe_id` = ?');
            $res->execute([$this->id]);

            $this->required_items = $res->fetchAll();
        }

        return $this->required_items;
    }

    /**
     * @return array
     */
    public function getResultItems()
    {
        if (!$this->result_items) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare('SELECT * FROM `recipe_result_items` WHERE `recipe_id` = ?');
            $res->execute([$this->id]);

            $this->result_items = $res->fetchAll();
        }

        return $this->result_items;
    }

    public function __destruct()
    {
        parent::__destruct();
        if(!$this->id AND $this->title) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("INSERT INTO profession_recipes 
            (title, icon, profession_id) VALUES (?, ?, ?)");
            $res->execute([
                $this->title,
                $this->icon,
                $this->profession_id]);
            $this->id = $connection->lastInsertId();
        }
    }

    /**
     * @return string
     */
    public function getFromName()
    {
        return 'profession_recipes';
    }
}