<?php

namespace data;

/**
 * Профессия [profession]
 * @property string title
 * @property string description
 * @property string icon
 */
class Profession extends \Data
{
    protected $title;
    protected $description = '';
    protected $icon = '';

    protected $recipes = [];
    private $count_recipes = 0;

    /**
     * @return int
     */
    public function getCountRecipes()
    {
        if (!$this->count_recipes) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT COUNT(*) FROM `profession_recipes` 
            WHERE `profession_id` = ?");
            $res->execute([$this->id]);
            $this->count_recipes = $res->fetchColumn();
        }
        return $this->count_recipes;
    }

    /**
     * @param string $limit
     * @return Recipe[]
     */
    public function getRecipes(string $limit)
    {
        if (!$this->recipes) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT id, id, life, energy, exp, title, profession_id, doodad_id, icon
            FROM `profession_recipes` 
            WHERE `profession_id` = ? LIMIT {$limit}");
            $res->execute([$this->id]);
            $this->recipes = $res->fetchAll(\PDO::FETCH_UNIQUE|\PDO::FETCH_CLASS, Recipe::class);
        }
        return $this->recipes;
    }

    /**
     * @param int $id
     * @return Recipe
     */
    public function findRecipe(int $id = 0) {
        if(!isset($this->recipes[$id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT * FROM `profession_recipes` 
            WHERE `id` = ? AND `profession_id` = ? LIMIT 1");
            $res->execute([$id, $this->id]);
            $this->recipes[$id] = $res->fetchObject(Recipe::class);
        }
        return $this->recipes[$id];
    }

    public function __destruct()
    {
        parent::__destruct();
        if(!$this->id AND $this->title) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("INSERT INTO professions 
            (title, description, icon) VALUES (?, ?, ?)");
            $res->execute([
                $this->title,
                $this->description,
                $this->icon]);
            $this->id = $connection->lastInsertId();
        }
    }

    /**
     * @return string
     */
    public function getFromName()
    {
        return 'professions';
    }
}