<?php

namespace data;

/**
 * Class Npc
 * @package data
 * @property string title
 * @property string icon
 */
class Npc extends \Data
{
    protected $title;
    protected $icon;
    protected $vendors = [];

    /**
     * @return string
     */
    public function getFromName()
    {
        return 'npcs';
    }

    public function getVendors() {
        if (!$this->vendors) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare('SELECT vendor_id, vendor_id, npc_id
            FROM `npc_vendors` WHERE `npc_id` = ?');
            $res->execute([$this->id]);

            $this->vendors = $res->fetchAll(\PDO::FETCH_UNIQUE);
        }

        return $this->vendors;
    }

    public function findVendor(int $id = null) {
        if(!isset($this->vendors[$id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT * FROM `npc_vendors` 
            WHERE `vendor_id` = ? AND npc_id = ? LIMIT 1");
            $res->execute([$id, $this->id]);
            $this->vendors[$id] = $res->fetch();
        }
        return $this->vendors[$id];
    }
}