<?php

namespace data;

/**
 * @property string title
 * @property string description
 * @property string icon
 * @property int count
 * @property int type
 * @property int buy
 */
class Item extends \Data
{
    protected $title;
    protected $description = '';
    protected $icon = '';
    protected $count = 1;
    protected $type = 0;
    protected $sell = 0;
    protected $buy = 0;

    public function __destruct()
    {
        parent::__destruct();
        if(!$this->id AND $this->title) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("INSERT INTO items 
            (title, description, icon, type, count) VALUES (?, ?, ?, ?, ?)");
            $res->execute([
                $this->title,
                $this->description,
                $this->icon,
                $this->type,
                $this->count]);
            $this->id = $connection->lastInsertId();
        }
    }

    /**
     * @return string
     */
    public function getFromName()
    {
        return 'items';
    }
}