<?php

namespace data;

/**
 * @property string title
 * @property string icon
 * @property string description
 * @property mixed parent_id
 */
class Achievement extends \Data
{
    protected $achievement_id = 0;
    protected $parent_id = 0;
    protected $title;
    protected $description;
    protected $icon;

    protected $achievements = [];
    protected $steps = [];

    /**
     * @return Achievement[]
     */
    public function getAchievements()
    {
        if (!$this->achievements) {
            /** @var \PDO $pdo */
            $pdo = \Registry::get('pdo');

            $res = $pdo->prepare("SELECT id, id, title, icon, description, parent_id
            FROM `achievements` 
            WHERE parent_id = ?");
            $res->execute([$this->id]);
            $this->achievements = $res->fetchAll(\PDO::FETCH_UNIQUE|\PDO::FETCH_CLASS, Achievement::class);
        }
        return $this->achievements;
    }

    /**
     * @return Profession[]
     */
    public function getSteps()
    {
        if (!$this->steps) {
            /** @var \PDO $pdo */
            $pdo = \Registry::get('pdo');

            $res = $pdo->prepare("SELECT *
            FROM `achievement_steps`
            WHERE `achievement_id` = ?");
            $res->execute([$this->id]);
            $this->steps = $res->fetchAll();
        }
        return $this->steps;
    }

    /**
     * @param int $id
     * @return Achievement
     */
    public function findAchievement(int $id = 0) {
        if(!isset($this->achievements[$id])) {
            /** @var \PDO $pdo */
            $pdo = \Registry::get('pdo');

            $res = $pdo->prepare("SELECT * FROM `achievements` 
            WHERE `id` = ? AND parent_id = ? LIMIT 1");
            $res->execute([$id, $this->id]);
            $this->achievements[$id] = $res->fetchObject(Achievement::class);
        }
        return $this->achievements[$id];
    }

    /**
     * @return string
     */
    public function getFromName()
    {
        return 'achievements';
    }
}