<?php

namespace data;

/**
 * Class Quest
 * @package data\account\event
 *
 * @method string getConfig()
 * @method setConfig(string $config)
 */
class Account_Quest extends \Data
{
    /**
     * Quest constructor.
     * @param int $quest_id
     * @param int $account_id
     */
    public function __construct($quest_id = 0, $account_id = 0)
    {
        $this->quest_id = $quest_id;
        $this->account_id = $account_id;
    }

    protected $account_id = 0;
    protected $quest_id = 0;
    protected $config = '{}';

    public function __destruct()
    {
        parent::__destruct();
        if(!$this->id AND $this->quest_id AND $this->account_id) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("INSERT INTO account_quests 
            (quest_id, account_id, config) VALUES (?, ?, ?)");
            $res->execute([$this->quest_id , $this->account_id, $this->config]);
            $this->id = $connection->lastInsertId();
        }
    }

    /**
     * @return string
     */
    public function getFromName()
    {
        return 'account_quests';
    }
}