<?php

namespace data;

use ui\Progress;

/**
 * Class Profession
 * @package data\account\event
 * @property int exp
 */
class Account_Profession extends \Data
{
    /**
     * Profession constructor.
     * @param int $profession_id
     * @param int $account_id
     */
    public function __construct($profession_id = 0, $account_id = 0)
    {
        $this->profession_id = $profession_id;
        $this->account_id = $account_id;
    }

    protected $account_id = 0;
    protected $profession_id = 0;
    protected $exp = 0;
    protected $config = '{}';

    private $exp_progress;

    /**
     * @return Progress
     */
    public function getExpProgress()
    {
        if (!$this->exp_progress) {
            $this->exp_progress = new Progress($this->exp, [
                0 => 5000,
                1 => 10000,
                2 => 15000,
                3 => 20000,
                4 => 30000,
                5 => 40000,
                6 => 55000,
                7 => 70000,
                8 => 90000,
                9 => 120000,
                10 => 150000,
            ]);
        }
        return $this->exp_progress;
    }

    public function __destruct()
    {
        parent::__destruct();
        if(!$this->id AND $this->profession_id AND $this->account_id) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("INSERT INTO account_professions 
            (profession_id, account_id, config) VALUES (?, ?, ?)");
            $res->execute([$this->profession_id , $this->account_id, $this->config]);
            $this->id = $connection->lastInsertId();
        }
    }

    /**
     * @return string
     */
    public function getFromName()
    {
       return 'account_professions';
    }
}