<?php

namespace data;

/**
 * Class Achievement
 * @package data\account\event
 *
 * @property int account_id
 * @property int achievement_id
 * @property int achievement_category
 * @property int step
 * @property int exp
 * @property string config
 */
class Account_Achievement extends \Data
{
    /**
     * Achievement constructor.
     * @param int $achievement_id
     * @param int $achievement_category
     * @param int $account_id
     */
    public function __construct($achievement_id = 0, $achievement_category = 0, $account_id = 0)
    {
        $this->achievement_id = $achievement_id;
        $this->achievement_category = $achievement_category;
        $this->account_id = $account_id;
    }

    protected $account_id = 0;
    protected $achievement_id = 0;
    protected $achievement_category = 0;
    protected $step = 0;
    protected $exp = 0;
    protected $config = '{}';

    /**
     * @param $name
     * @return int
     */
    public function getConfigInt($name) {
        $config = json_decode($this->config, true);

        if(isset($config[$name])) {
            return $config[$name];
        }

        return 0;
    }

    /**
     * @param $name
     * @param $value
     */
    public function setConfigInt($name, $value) {
        $config = json_decode($this->config, true);
        $config[$name] = $value;
        $this->config = json_encode($config);
    }

    public function __destruct()
    {
        parent::__destruct();
        if(!$this->id AND $this->achievement_id AND $this->account_id) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("INSERT INTO account_achievements 
            (achievement_id, account_id, achievement_category, exp, step, config) VALUES (?, ?, ?, ?, ?, ?)");
            $res->execute([
                $this->achievement_id ,
                $this->account_id,
                $this->achievement_category,
                $this->exp,
                $this->step,
                $this->config]);
            $this->id = $connection->lastInsertId();
        }
    }

    /**
     * @return string
     */
    public function getFromName()
    {
        return 'account_achievements';
    }
}