<?php

namespace data;

use core\account\City;
use core\account\Craft;
use core\account\Event;
use core\account\Farm;
use core\account\Inventory;
use ui\Progress;
use ui\progress\Energy;

/**
 * @property string login
 * @property int slot_inventory
 * @property int money
 * @property int exp
 * @property int energy
 * @property int slot_craft
 * @property bool is_admin
 * @property int craft_reputation
 * @property int data_register
 */
class Account extends \Data
{
    protected $login;
    protected $slot_inventory = 10;
    protected $slot_craft = 10;
    protected $money = 0;
    protected $exp = 0;
    protected $energy = 100;
    protected $craft_reputation = 0;
    protected $data_register = 0;
    protected $is_admin = false;

    private $event;
    private $craft;
    private $inventory;
    private $exp_progress;
    private $energy_progress;
    private $farm;
    private $city;

    /**
     * @return City
     */
    public function getCity()
    {
        if(!$this->city) {
            $this->city = new City($this->id);
        }

        return $this->city;
    }

    /**
     * @return Farm
     */
    public function getFarm()
    {
        if(!$this->farm) {
            $this->farm = new Farm($this->id);
        }

        return $this->farm;
    }

    /**
     * @return Event
     */
    public function getEvent() {
        if(!$this->event) {
            $this->event = new Event($this->id);
        }

        return $this->event;
    }

    /**
     * @return Craft
     */
    public function getCraft() {
        if(!$this->craft) {
            $this->craft = new Craft($this->id);
        }

        return $this->craft;
    }

    /**
     * @return Inventory
     */
    public function getInventory() {
        if(!$this->inventory) {
            $this->inventory = new Inventory($this->id, $this->slot_inventory);
        }

        return $this->inventory;
    }

    /**
     * @return Progress
     */
    public function getExpProgress()
    {
        if (!$this->exp_progress) {
            $this->exp_progress = new Progress($this->exp, [
                1 => 5,
                2 => 10,
                3 => 20,
                4 => 40,
                5 => 80,
                6 => 160,
                7 => 320,
                8 => 640,
                9 => 1280,
                10 => 2560,
                11 => 5120,
                12 => 10240,
                13 => 20480,
                14 => 40960,
                15 => 81920
            ]);
        }
        return $this->exp_progress;
    }

    /**
     * @return Energy
     */
    public function getEnergyProgress()
    {
        if (!$this->energy_progress) {
            $this->energy_progress = new Energy($this, [
                1 => 100,
                2 => 200,
                3 => 300,
                4 => 400,
                5 => 500,
                6 => 600
            ]);
        }
        return $this->energy_progress;
    }

    /**
     * @return string
     */
    public function getFromName()
    {
        return 'accounts';
    }
}