<?php

/**
 * @property int id
 */
abstract class Data
{
    protected $id = 0;
    protected $update = [];

    /**
     * @param $name
     * @param $value
     */
    public function __set($name, $value){
        if(property_exists($this, $name) AND !array_key_exists($name, ['id', 'update'])) {
            $this->{$name} = $value;
            $this->update[$name] = $value;
        }
    }

    /**
     * @param $name
     * @return mixed
     */
    public function __get($name)
    {
        if(isset($this->update[$name])) {
            return $this->update[$name];
        }

        if(property_exists($this, $name)) {
            return $this->{$name};
        }

        return false;
    }

    public function __destruct()
    {
        if($this->id AND $this->update) {
            /** @var \PDO $connection */
            $connection = Registry::get('connection');
            $sql = array();

            foreach ($this->update as $key => $value) {
                $sql[] = "`" . $key . "` = " . $connection->quote($value);
            }

            $setSql = implode(', ', $sql);

            $res = $connection->prepare("UPDATE {$this->getFromName()} SET {$setSql} WHERE `id` = ? LIMIT 1");
            $res->execute([$this->id]);

            $this->update = [];
        }
    }

    /**
     * @return bool
     */
    public function isUpdate() {
        if ($this->id AND $this->update) {
            return true;
        }

        return false;
    }

    /**
     * @return string
     */
    public abstract function getFromName();
}