<?php

namespace core;

class View
{
    protected $path_dir;
    protected $assigned = [];

    /**
     * View constructor.
     * @param string $path_dir
     * @param array $assigned
     */
    public function __construct(string $path_dir, array $assigned = [])
    {
        $this->path_dir = $path_dir;
        foreach ($assigned AS $key => $value) {
            $this->assign($key, $value);
        }
    }

    /**
     * @param $name
     * @param null $value
     */
    public function assign($name, $value = null)
    {
        if (is_array($name)) {
            foreach ($name as $key => $value) {
                $this->assign($key, $value);
            }
            return;
        }
        if (is_scalar($name))
            $this->assigned[$name] = $value;
    }

    /**
     * @param $name
     * @return string
     * @throws \Exception
     */
    public function render($name) {
        if (!is_file($this->path_dir . '/' . $name . '.php')) {
            return false;
        }

        extract($this->assigned);
        ob_start();
        include $this->path_dir . '/' . $name . '.php';
        $content = ob_get_clean();
        return (string)$content;
    }
}