<?php

namespace core\response;

use core\Response;

class Redirect extends Response
{
    protected $url;
    protected $temporarily = true;

    public function send()
    {
        $this->setStatus($this->isTemporarily() ? 302 : 301);
        $this->setHeaders([
            "Location: " . $this->getUrl()
        ]);
        parent::send();
    }

    /**
     * @return mixed
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param mixed $url
     */
    public function setUrl($url)
    {
        $this->url = $url;
    }

    /**
     * @return boolean
     */
    public function isTemporarily()
    {
        return $this->temporarily;
    }

    /**
     * @param boolean $temporarily
     */
    public function setTemporarily($temporarily)
    {
        $this->temporarily = $temporarily;
    }
}