<?php

namespace core\account;

class Farm
{
    protected $account_id = 0;
    protected $seeds = [];
    protected $animals = [];

    private $count_seeds = 0;
    private $count_animals = 0;

    /**
     * Craft constructor.
     * @param int $account_id
     */
    public function __construct($account_id = 0)
    {
        $this->account_id = $account_id;
    }

    /**
     * @return int
     */
    public function getCountSeeds()
    {
        if (!$this->count_seeds) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT COUNT(*) FROM `account_seeds` WHERE `account_id` = ?");
            $res->execute([$this->account_id]);
            $this->count_seeds = $res->fetchColumn();
        }
        return $this->count_seeds;
    }

    /**
     * @param string $limit
     * @return \array[]
     */
    public function getSeeds(string $limit)
    {
        if (!$this->seeds) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT id, id, seed_id, time_end FROM `account_seeds` WHERE `account_id` = ?
            LIMIT {$limit}");
            $res->execute([$this->account_id]);
            $this->seeds = $res->fetchAll(\PDO::FETCH_UNIQUE|\PDO::FETCH_ASSOC);
        }
        return $this->seeds;
    }

    /**
     * @param int $id
     * @return array
     */
    public function findSeed(int $id = null) {
        if(!isset($this->seeds[$id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT * FROM `account_seeds` 
            WHERE `id` = ? AND `account_id` = ? LIMIT 1");
            $res->execute([$id, $this->account_id]);
            $this->seeds[$id] = $res->fetch(\PDO::FETCH_ASSOC);
        }
        return $this->seeds[$id];
    }

    /**
     * @return int
     */
    public function getCountAnimals()
    {
        if (!$this->count_animals) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT COUNT(*) FROM `account_animals` WHERE `account_id` = ?");
            $res->execute([$this->account_id]);
            $this->count_animals = $res->fetchColumn();
        }
        return $this->count_animals;
    }

    /**
     * @param string $limit
     * @return \array[]
     */
    public function getAnimals(string $limit)
    {
        if (!$this->animals) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT id, id, animal_id, time_end FROM `account_animals` WHERE `account_id` = ?
            LIMIT {$limit}");
            $res->execute([$this->account_id]);
            $this->animals = $res->fetchAll(\PDO::FETCH_UNIQUE|\PDO::FETCH_ASSOC);
        }
        return $this->animals;
    }

    /**
     * @param int $id
     * @return array
     */
    public function findAnimal(int $id = null) {
        if(!isset($this->animals[$id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT * FROM `account_animals` 
            WHERE `id` = ? AND `account_id` = ? LIMIT 1");
            $res->execute([$id, $this->account_id]);
            $this->animals[$id] = $res->fetch(\PDO::FETCH_ASSOC);
        }
        return $this->animals[$id];
    }
}