<?php

namespace core\account;

class Craft
{
    protected $account_id = 0;
    protected $tasks = [];
    private $count_tasks = 0;

    /**
     * Craft constructor.
     * @param int $account_id
     */
    public function __construct($account_id = 0)
    {
        $this->account_id = $account_id;
    }

    /**
     * @return int
     */
    public function getCountTasks ()
    {
        if (!$this->count_tasks) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT COUNT(*) FROM `craft_tasks` WHERE `account_id` = ?");
            $res->execute([$this->account_id]);
            $this->count_tasks = $res->fetchColumn();
        }
        return $this->count_tasks;
    }

    /**
     * @param string $limit
     * @return \array[]
     */
    public function getTasks(string $limit)
    {
        if (!$this->tasks) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT id, id, recipe_id, time_end FROM `craft_tasks` WHERE `account_id` = ? 
            LIMIT {$limit}");
            $res->execute([$this->account_id]);
            $this->tasks = $res->fetchAll(\PDO::FETCH_UNIQUE|\PDO::FETCH_ASSOC);
        }
        return $this->tasks;
    }

    /**
     * @param int $id
     * @return array
     */
    public function findTask(int $id = null) {
        if(!isset($this->tasks[$id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT * FROM `craft_tasks` 
            WHERE `id` = ? AND `account_id` = ? LIMIT 1");
            $res->execute([$id, $this->account_id]);
            $this->tasks[$id] = $res->fetch(\PDO::FETCH_ASSOC);
        }
        return $this->tasks[$id];
    }
}