<?php

namespace core\account;

class City
{
    protected $account_id = 0;
    protected $npcs = [];
    protected $buildings = [];

    /**
     * Craft constructor.
     * @param int $account_id
     */
    public function __construct($account_id = 0)
    {
        $this->account_id = $account_id;
    }

    /**
     * @param int $building_id
     * @return array
     */
    public function getNpcs($building_id = 0)
    {
        if (!isset($this->npcs[$building_id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT id, id, npc_id, building_id
            FROM `city_npcs` 
            WHERE `account_id` = ? OR `account_id` IS NULL AND building_id = ?");
            $res->execute([$this->account_id, $building_id]);
            $this->npcs[$building_id] = $res->fetchAll(\PDO::FETCH_UNIQUE | \PDO::FETCH_ASSOC);
        }
        return $this->npcs[$building_id];
    }

    /**
     * @param int $id
     * @param int $building_id
     * @return array
     */
    public function findNpc(int $id = null, $building_id = 0) {
        if(!isset($this->npcs[$building_id][$id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT * FROM `city_npcs` 
            WHERE `id` = ? AND (`account_id` = ? OR `account_id` IS NULL) AND building_id = ? LIMIT 1");
            $res->execute([$id, $this->account_id, $building_id]);
            $this->npcs[$building_id][$id] = $res->fetch(\PDO::FETCH_ASSOC);
        }

        return $this->npcs[$building_id][$id];
    }

    /**
     * @param int $parent_id
     * @return array
     */
    public function getBuildings($parent_id = 0)
    {
        if (!isset($this->buildings[$parent_id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT id, id, building_id, parent_id
            FROM `city_buildings` 
            WHERE (`account_id` = ? OR `account_id` IS NULL) AND parent_id = ?");
            $res->execute([$this->account_id, $parent_id]);
            $this->buildings[$parent_id] = $res->fetchAll(\PDO::FETCH_UNIQUE | \PDO::FETCH_ASSOC);
        }
        return $this->buildings[$parent_id];
    }

    /**
     * @param int $id
     * @param int $parent_id
     * @return array
     */
    public function findBuilding(int $id = null, $parent_id = 0) {
        if(!isset($this->buildings[$parent_id][$id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT * FROM `city_buildings` 
            WHERE `id` = ? AND (`account_id` = ? OR `account_id` IS NULL) AND parent_id = ? LIMIT 1");
            $res->execute([$id, $this->account_id, $parent_id]);
            $this->buildings[$parent_id][$id] = $res->fetch(\PDO::FETCH_ASSOC);
        }
        return $this->buildings[$parent_id][$id];
    }
}