<?php

use data\Account;
use data\Animal;
use data\Building;
use data\Item;
use data\Npc;
use data\Profession;
use data\Recipe;
use data\Seed;
use data\Vendor;

abstract class Core
{
    protected static $seeds = [];
    protected static $animals = [];
    protected static $accounts = [];
    protected static $items = [];
    protected static $professions = [];
    protected static $recipes = [];
    protected static $npcs = [];
    protected static $buildings = [];
    protected static $vendors = [];

    private static $count_professions = 0;
    private static $count_items = 0;

    /**
     * @return Profession[]
     */
    public static function getSeeds()
    {
        if (!self::$seeds) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->query("SELECT id, id, item_id, item_count FROM `seeds`");
            self::$seeds = $res->fetchAll(\PDO::FETCH_UNIQUE|\PDO::FETCH_CLASS, Seed::class);
        }

        return self::$seeds;
    }

    /**
     * @return int
     */
    public static function getCountItems()
    {
        if (!self::$count_items) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->query("SELECT COUNT(*) FROM `items` ");
            self::$count_items = $res->fetchColumn();
        }
        return self::$count_items;
    }

    /**
     * @param string $limit
     * @return \data\Profession[]
     */
    public static function getItems(string $limit)
    {
        if (!self::$items) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->query("SELECT id, id, title, icon, count, sell, buy FROM `items` LIMIT {$limit}");
            self::$items = $res->fetchAll(\PDO::FETCH_UNIQUE|\PDO::FETCH_CLASS, Item::class);
        }

        return self::$items;
    }

    /**
     * @return int
     */
    public static function getCountProfessions()
    {
        if (!self::$count_professions) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->query("SELECT COUNT(*) FROM `professions` ");
            self::$count_professions = $res->fetchColumn();
        }
        return self::$count_professions;
    }

    /**
     * @param string $limit
     * @return \data\Profession[]
     */
    public static function getProfessions(string $limit)
    {
        if (!self::$professions) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->query("SELECT id, id, title, icon FROM `professions` LIMIT {$limit}");
            self::$professions = $res->fetchAll(\PDO::FETCH_UNIQUE|\PDO::FETCH_CLASS, Profession::class);
        }
        return self::$professions;
    }


    /**
     * @param int $id
     * @return Seed
     */
    public static function findSeed(int $id = null) {
        if (!isset(self::$seeds[$id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT * FROM seeds WHERE id = ? LIMIT 1");
            $res->execute([$id]);

            self::$seeds[$id] = $res->fetchObject(Seed::class);
        }

        return self::$seeds[$id];
    }

    /**
     * @param int $id
     * @return Seed
     */
    public static function findAnimal(int $id = null) {
        if (!isset(self::$animals[$id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT * FROM animals WHERE id = ? LIMIT 1");
            $res->execute([$id]);

            self::$animals[$id] = $res->fetchObject(Animal::class);
        }

        return self::$animals[$id];
    }

    /**
     * @param int $id
     * @return Account
     */
    public static function findAccount(int $id = null) {
        if (!isset(self::$accounts[$id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT * FROM accounts WHERE id = ? LIMIT 1");
            $res->execute([$id]);

            self::$accounts[$id] = $res->fetchObject(Account::class);
        }

        return self::$accounts[$id];
    }

    /**
     * @param int $id
     * @return Item
     */
    public static function findItem($id = null) {
        if(!isset(self::$items[$id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT * FROM `items` WHERE `id` = ? LIMIT 1");
            $res->execute([$id]);

            self::$items[$id] = $res->fetchObject(Item::class);
        }

        return self::$items[$id];
    }

    /**
     * @param int $id
     * @return Profession
     */
    public static function findProfession($id = null) {
        if(!isset(self::$professions[$id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT * FROM `professions` WHERE `id` = ? LIMIT 1");
            $res->execute([$id]);
            self::$professions[$id] = $res->fetchObject(Profession::class);
        }
        return self::$professions[$id];
    }

    /**
     * @param int $id
     * @return Recipe
     */
    public static function findRecipe(int $id = null) {
        if(!isset(self::$recipes[$id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT * FROM `profession_recipes` 
            WHERE `id` = ? LIMIT 1");
            $res->execute([$id]);
            self::$recipes[$id] = $res->fetchObject(Recipe::class);
        }
        return self::$recipes[$id];
    }

    /**
 * @param int $id
 * @return Building
 */
    public static function findBuilding(int $id = null) {
        if(!isset(self::$buildings[$id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT * FROM `buildings` 
            WHERE `id` = ? LIMIT 1");
            $res->execute([$id]);
            self::$buildings[$id] = $res->fetchObject(Building::class);
        }
        return self::$buildings[$id];
    }

    /**
     * @param int $id
     * @return Npc
     */
    public static function findNpc(int $id = null) {
        if(!isset(self::$npcs[$id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT * FROM `npcs` 
            WHERE `id` = ? LIMIT 1");
            $res->execute([$id]);
            self::$npcs[$id] = $res->fetchObject(Npc::class);
        }
        return self::$npcs[$id];
    }

    /**
     * @param int $id
     * @return Vendor
     */
    public static function findVendor(int $id = null) {
        if(!isset(self::$vendors[$id])) {
            /** @var \PDO $connection */
            $connection = \Registry::get('connection');

            $res = $connection->prepare("SELECT * FROM `vendors` 
            WHERE `id` = ? LIMIT 1");
            $res->execute([$id]);
            self::$vendors[$id] = $res->fetchObject(Vendor::class);
        }
        return self::$vendors[$id];
    }
}