<?php

abstract class Configurator
{
    protected $__id;

    /**
     * Configurator constructor.
     * @param array $config
     */
    public function __construct($config = [])
    {
        $this->__id = $this->__getNewId();
        if ($config) {
            $this->setConfig($config);
        }
    }

    /**
     * @return string
     */
    protected function __getNewId()
    {
        static $id = array();
        $class = get_class($this);
        return $class . '_' . @++$id[$class];
    }

    /**
     * @return string
     */
    public function getID()
    {
        return $this->__id;
    }

    protected function setConfig(array $config)
    {
        foreach ($config AS $param_name => $param_value) {
            if (in_array($param_name, ['config'])) {
                continue;
            }

            $method_name = 'set' . $param_name;

            if (!method_exists($this, $method_name)) {
                throw new \Exception('Метод ' . $method_name . ' отсутствует у класса ' . get_class($this));
            }

            $this->$method_name($param_value);
        }
    }

    protected static function compileNameClass($namespace)
    {
        return strtolower((new \ReflectionClass($namespace))->getShortName());
    }
}