<?php

abstract class Component
{
    protected $name;
    protected $type;
    protected $version;
    protected $config = [];
    protected $system = false;
    protected $enabled = false;
    protected $installed = false;

    public function __construct()
    {

    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }

    /**
     * @return boolean
     */
    public function isInstalled(): bool
    {
        return $this->installed;
    }

    /**
     * @return boolean
     */
    public function isEnabled(): bool
    {
        return $this->enabled;
    }

    /**
     * @return boolean
     */
    public function isSystem(): bool
    {
        return $this->system;
    }

    /**
     * @return array
     */
    public function getConfig(): array
    {
        return $this->config;
    }

    /**
     * @param $name
     * @return array
     * @throws Exception
     */
    public function findConfig($name)
    {
        $config = Json::parse($this->config);

        if(isset($config[$name])) {
            return $config[$name];
        }

        return null;
    }
}