<?php

use core\Module;
use core\Request;
use core\Response;
use core\Router;
use core\Ui;

require_once __DIR__ . '/engine/core.php';

try {
    (new Module([
        'router' => $router = new Router(),
        'request' => $request = new Request(),
        'page' => $page = new Ui\Page([
            'stylesheets' => Theme::findResource(Theme::getCurrentTheme(), 'css'),
            'scripts' => Theme::findResource(Theme::getCurrentTheme(), 'js')
        ])
    ]))->bind(DIR_ENGINE . '/modules/*/module.php');

    try {
        $result = $router->bind($request);

        if (!$result) {
            $page->setTitle('Страница не найдено');
            $page->addBreadcrumb()->setItems([
                '<span class="icon white_arrow"></span><span class="text">Страница не найдено</span>'
            ]);
            $page->setItems([
                new Ui\Content([
                    'items' => [
                        new Ui\Item([
                            'items' => [
                                'Здравствуйте, Вы находитесь на странице ошибки 404.'
                            ]
                        ]),
                        new Ui\Item([
                            'items' => [
                                '<div><b>Возможные причины ошибки:</b></div>',
                                '<div>— ошибка при наборе адреса страницы (URL);</div>',
                                '<div>— переход по неработающей или неправильной ссылке;</div>',
                                '<div>— отсутствие запрашиваемой страницы на сайте;</div>'
                            ]
                        ]),
                        new Ui\Item([
                            'items' => [
                                '<div><b>Решения проблемы:</b></div>',
                                '<div>— проверить правильность написания адреса страницы (URL);</div>',
                                '<div>— перейти на главную страницу сайта;</div>',
                                '<div>— воспользоваться поиском;</div>',
                            ]
                        ]),
                        new Ui\Item([
                            'items' => [
                                'Просим сообщить об этой проблеме владельцу сайта при помощи формы обратной связи или электронной почты.',
                            ]
                        ])
                    ]
                ])
            ]);
            $result = $page;
        }
        if (!$result instanceof Response) {
            $response = new Response\Html();
            $response->setContent($result);
            $result = $response;
        }

        $result->send();
    } catch (Exception $e) {
        $page->setTitle('Внутренняя ошибка сервера');
        $page->setItems([
            new Ui\Content([
                'items' => [
                    new Ui\Item([
                        'items' => [
                            '<pre style="white-space: pre-wrap">' .
                            $e->getMessage() . PHP_EOL .
                            $e->getTraceAsString() . PHP_EOL .
                            '</pre>'
                        ]
                    ])
                ]
            ])
        ]);
        $response = new Response\Html([
            "status" => 500,
            "content" => $page
        ]);
        $response->send();
    }
} catch (Exception $e) {
    http_response_code(500);
    header("Content-Type: text/plain");
    echo $e->getMessage() . PHP_EOL;
    echo $e->getTraceAsString();
}
