<?php
/**
 * @var \core\ui\Page $view
 */
$start_time = microtime(true);

?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html>
<head>
    <title><?= \Text::toValue($view->getTitle()) ?></title>
    <link rel="shortcut icon" href="/favicon.ico?v=2" type="image/x-icon">
    <?php
    foreach ($view->getStylesheets() AS $href) {
        $href = \Text::toValue($href);
        echo "<link rel='stylesheet' type='text/css' href='{$href}'>" . PHP_EOL;
    }
    foreach ($view->getScripts() AS $src) {
        $src = \Text::toValue($src);
        echo "<script type='text/javascript' src='{$src}'></script>" . PHP_EOL;
    } ?>
</head>
<body>
<table>
    <tr>
        <td class="border_angle_left_top"></td>
        <td class="border_horizontal"></td>
        <td class="border_angle_top_right"></td>
    </tr>
    <tr>
        <td class="border_vertical"></td>
        <td class="page">
            <?php if ($view->getBreadcrumbs()) { ?>
                <div class="breadcrumbs">
                    <div class="content">
                        <div class="item">
                            <?php foreach ($view->getBreadcrumbs() AS $breadcrumb) {
                                echo $breadcrumb;
                            } ?>
                        </div>
                    </div>
                </div>
            <?php } ?>
            <?php if (User::isAuth()) { ?>
                <div class="content">
                    <table>
                        <tr>
                            <td>
                                <div class="item">
                                    <a type="button" href="/account"
                                       style="min-width: 80px;min-height: 51px; padding-top: 6px">
                                        <div class="icon level" style="margin-top: 5px"></div>
                                        <div class="title" style="padding-top: 8px; padding-left: 0">
                                            <span
                                                style="font-weight: bold;"><?php echo User::getAccount()->getExpProgress()->getLevel() ?></span>
                                            уровень
                                        </div>
                                    </a>
                                </div>
                            </td>
                            <td style="width: 100%">
                                <div class="item">
                                    <div class="listing">
                                        <div class="content">
                                            <?php echo User::getAccount()->getExpProgress() ?>
                                            <?php echo User::getAccount()->getEnergyProgress() ?>
                                            <div class="item">
                                                <span class="money">
													Очки работы: <?php echo User::getAccount()->getEnergyProgress()->getEnergy() ?>
												</span>
                                                <span style="float: right">
                                                    <?php echo new \core\ui\Money(User::getAccount()->money) ?>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    </table>
                    <?php foreach (Flash::getSystemMessages() AS $message) { ?>
                        <?php echo new core\ui\Message([
                            'type' => $message['type'],
                            'title' => '<b>ИНФОРМАЦИЯ</b>',
                            'items' => [
                                new core\ui\Item([
                                    'items' => [
                                        $message['text']
                                    ]
                                ])
                            ]
                        ]); ?>
                    <?php } ?>
                </div>
                <div class="block">
                    <div class="left"></div>
                    <div class="right"></div>
                </div>
            <?php } ?>
            <?php foreach ($view->getItems() AS $item) {
                echo $item;
            } ?>
            <?php if (User::isAuth() AND $account_menu = $view->findListMenu('account_menu')) { ?>
                <div class="block">
                    <div class="left"></div>
                    <div class="right"></div>
                </div>
                <div class="content">
                    <table>
                        <tr>
                            <?php foreach ($account_menu AS $data) { ?>
                                <td style="width: 25%">
                                    <div class="item">
                                        <a type="button" href="<?php echo $data['url'] ?>" class="model fixed">
                                            <span class="icon <?php echo $data['icon'] ?>">
                                                <?php if (isset($data['count']) AND $data['count']) { ?>
                                                    <span class="count"><?php echo $data['count'] ?></span>
                                                <?php } ?>
                                            </span>
                                            <span class="title"><?php echo $data['title'] ?></span>
                                        </a>
                                    </div>
                                </td>
                            <?php } ?>
                        </tr>
                    </table>
                </div>
            <?php } ?>
        </td>
        <td class="border_vertical"></td>
    </tr>
    <tr>
        <td class="border_angle_bottom_left"></td>
        <td class="border_horizontal"></td>
        <td class="border_angle_right_bottom"></td>
    </tr>
</table>
<div class="content" style="text-align: center">
    <?php if ($foot_menu = $view->findListMenu('foot_menu')) { ?>
        <div class="item">
            <?php foreach ($foot_menu AS $data) { ?>
                <a href="<?php echo $data['url'] ?>" class="link"><?php echo $data['title'] ?></a>
            <?php } ?>
        </div>
    <?php } ?>
    <div class="item">
        <div style="color: #f1f1f1">Генерация: <?php echo round(microtime(true) - $start_time, 4); ?> сек</div>
    </div>
</div>
</body>
</html>
