<?php

namespace npc\classes;

use core\Ui;
use core\Response;
use core\Url;
use data\Npc;

class Component extends \Component
{
    /**
     * @param Npc $data
     * @param Ui\Page $page
     * @return mixed
     */
    public function execute(Npc $data, Ui\Page $page)
    {
        if (isset($_GET['quest'])) {
            $page->addBreadcrumb([
                'url' => new Url(null, ['id' => $data->id]),
                'items' => [
                    '<span class="icon white_arrow"></span><span class="text">' . $this->title .'</span>'
                ]
            ]);
            return $page;
        }

        $page->setTitle($this->title);
        $page->addBreadcrumb([
            'items' => [
                '<span class="icon white_arrow"></span><span class="text">' . $this->title .'</span>'
            ]
        ]);
        return $page;
    }
}