<?php

namespace event\components\celebratory_cake;

use core\Response;
use core\Ui;
use core\Url;
use data\profession\Recipe;
use event\classes\doneCraftTask;

class Component extends \event\classes\Component implements doneCraftTask
{
    public function onDoneCraftTask(Recipe $recipe)
    {
        $random = rand(0, 10000);
        if ($random <= 3000) {
            return [
                [
                    'item_id' => 10,
                    'count' => 1,
                    'is_cube' => true
                ]
            ];
        }

        return [];
    }

    public function execute(array $event, Ui\Page $page)
    {
        if(isset($_GET['effect'])) {
            $effect = $_GET['effect'];

            $res = \Core::getConnection()->prepare('SELECT * FROM account_effects 
                WHERE account_id = ? AND name = ? AND time_end > ?
                LIMIT 1');
            $res->execute([\User::getAccount()->id, $effect, time()]);
            if (!$res->fetch()) {
                if (!\User::getAccount()->getInventory()->deleteItem([
                    'item_id' => 10,
                    'count' => 5
                ])
                ) {
                    \Flash::addMessageError('Не хватает свечек');
                } else {
                    switch ($effect) {
                        case 'exp';
                            $res = \Core::getConnection()->prepare('INSERT INTO account_effects
                            (name, point, time_end, account_id) VALUES (?, ?, ?, ?)');
                            $res->execute([$effect, 100, time() + 10800, \User::getAccount()->id]);

                            break;
                        case 'craft_exp';
                            $res = \Core::getConnection()->prepare('INSERT INTO account_effects
                            (name, point, time_end, account_id) VALUES (?, ?, ?, ?)');
                            $res->execute([$effect, 80, time() + 10800, \User::getAccount()->id]);

                            break;
                        case 'craft_reputation';
                            $res = \Core::getConnection()->prepare('INSERT INTO account_effects
                            (name, point, time_end, account_id) VALUES (?, ?, ?, ?)');
                            $res->execute([$effect, 60, time() + 10800, \User::getAccount()->id]);

                            break;
                        default;
                            \Flash::addMessageError('Не известный параметры еффекта');
                            break;
                    }
                }
            }

            return new Response\Redirect([
                'url' => (new Url())->removeParam('effect')
            ]);
        }

        $page = parent::execute($event, $page);

        $page->setItems([
            $content = new Ui\Content([
                'items' => [
                    $ui_messages = new Ui()
                ]
            ])
        ]);

        $listing = $content->addUiItem()->addUiListing();

        $content_listing = $listing->addUiContent();
        $content_listing->addUiItem()->setItems([
            '<b>Как получить свечки?</b>'
        ]);
        $content_listing->addUiItem()->setItems([
            'Необходимо выполнять ремесленую задачу, щанс выпадения свечку состоит из 30% и перемешает в куб инвентаря'
        ]);

        $content_listing->addUiItem()->setItems([
            '<b>Как получить бонус?</b>'
        ]);
        $content_listing->addUiItem()->setItems([
            'Чтобы получить бонус необходимо иметь 5 свечки.'
        ]);

        $content_listing = $listing->addUiContent();
        $content_listing->addUiItem()->addItem('Бонус-эффект: Получаемый опыт + 100%');

        $res = \Core::getConnection()->prepare('SELECT * FROM account_effects 
                WHERE name = ? AND time_end > ?
                LIMIT 1');
        $res->execute(['exp', time()]);

        if($data = $res->fetch()) {
            $content_listing->addUiItem()->addItem(sprintf('До повтора получения осталось: %s', when($data['time_end'])));
        } else {
            $content_listing->addUiItem()->addItem(new Ui\Button([
                'url' => new Url(null, ['effect' => 'exp']),
                'items' => [
                    'Получить бонус'
                ]
            ]));
        }

        $content_listing = $listing->addUiContent();
        $content_listing->addUiItem()->addItem('Бонус-эффект: Получаемый ремесленый опыт + 80%');

        $res = \Core::getConnection()->prepare('SELECT * FROM account_effects 
                WHERE name = ? AND time_end > ?
                LIMIT 1');
        $res->execute(['craft_exp', time()]);

        if($data = $res->fetch()) {
            $content_listing->addUiItem()->addItem(sprintf('До повтора получения осталось: %s', when($data['time_end'])));
        } else {
            $content_listing->addUiItem()->addItem(new Ui\Button([
                'url' => new Url(null, ['effect' => 'craft_exp']),
                'items' => [
                    'Получить бонус'
                ]
            ]));
        }

        $content_listing = $listing->addUiContent();
        $content_listing->addUiItem()->addItem('Бонус-эффект: Получаемый ремесленая репутация + 60%');

        $res = \Core::getConnection()->prepare('SELECT * FROM account_effects 
                WHERE name = ? AND time_end > ?
                LIMIT 1');
        $res->execute(['craft_reputation', time()]);

        if($data = $res->fetch()) {
            $content_listing->addUiItem()->addItem(sprintf('До повтора получения осталось: %s', when($data['time_end'])));
        } else {
            $content_listing->addUiItem()->addItem(new Ui\Button([
                'url' => new Url(null, ['effect' => 'craft_reputation']),
                'items' => [
                    'Получить бонус'
                ]
            ]));
        }

        foreach (\Flash::getMessages() AS $message) {
            $ui_messages->addItem(new Ui\Message([
                'type' => $message['type'],
                'items' => [
                   new Ui\Item([
                       'items' => [
                           $message['text']
                       ]
                   ])
                ]
            ]));
        }

        return $page;
    }
}