<?php

use data\profession\Recipe;
use event\classes\doneCraftTask;

/**
 * Class Effect
 * @method static event\classes\Component findComponent($name)
 */
abstract class Event extends \Package
{
    public static function doneCraftTask(Recipe $recipe)
    {
        $items = [];

        /** @var doneCraftTask $component */
        foreach (self::getList() AS $name) {
            $res = Core::getConnection()->prepare('SELECT * FROM location_events WHERE name = ? AND time_end > ?');
            $res->execute([$name, time()]);

            if (!$res->fetch()) {
                continue;
            }

            $component = self::findComponent($name);
            if (!in_array(doneCraftTask::class, class_implements($component))) {
                continue;
            }

            $items = array_merge($items, $component->onDoneCraftTask($recipe));
        }

        return $items;
    }
}