<?php

namespace effect\components\craft_reputation;

use core\Response;
use core\Ui;
use data\Building;

class Component extends \effect\classes\Component
{
    protected $percent;

    public function getPercent()
    {
        if (!$this->percent) {
            $this->percent = parent::getPercent();

            $res = \Core::getConnection()->prepare('SELECT SUM(point) AS all_percent 
            FROM account_effects 
            WHERE account_id = ? AND name = ? AND time_end > ?');
            $res->execute([\User::getAccount()->id, $this->name, time()]);

            if($data = $res->fetch()) {
                $this->percent += $data['all_percent'];
            }
        }

        return $this->percent;
    }

    public function getTotal($point) {
        return $point * $this->getPercent() / 100;
    }
}