<?php

namespace building\classes;

use core\Ui;
use core\Response;
use core\Url;
use data\Building;

class Component extends \Component
{
    /**
     * @param Building $data
     * @param Ui\Page $page
     * @return mixed
     */
    public function execute(Building $data, Ui\Page $page)
    {
        if (isset($_GET['npc'])) {
            if (!$npc = $data->findNpc(filter_input(INPUT_GET, 'npc', FILTER_SANITIZE_NUMBER_INT))) {
                return new Response\Redirect([
                    'url' => (new Url())->removeParam('npc')
                ]);
            }

            $page->addBreadcrumb([
                'url' => new Url($data->name),
                'items' => [
                    '<span class="icon white_arrow"></span><span class="text">' . $this->title .'</span>'
                ]
            ]);
            return \Npc::findComponent($npc->name)->execute($npc, $page);
        }

        $page->setTitle($this->title);
        $page->addBreadcrumb([
            'items' => [
                '<span class="icon white_arrow"></span><span class="text">' . $this->title .'</span>'
            ]
        ]);
        return $page;
    }
}