<?php
/**
 * @var \core\Module $this
 * @var \core\Router $router
 * @var \core\Request $request
 * @var \core\ui\Page $page
 */

use core\Ui;
use core\Url;
use core\Module;

if (User::getAccount()->isAccess(Group::ADMINISTRATOR)) {
    $page->addMenu('foot_menu', [
        'url' => '/panel',
        'title' => 'Панель управления'
    ]);
    $panel = $router->addGroup('/panel', function () use ($page) {
        $page->setTitle('Панель управления');

        $page->setItems([
            $content = new Ui\Content([
                'items' => [
                    $ui = new Ui()
                ]
            ])
        ]);
        $ui->addItem(new Ui\Item([
            'items' => [
                $tabs = new Ui(),
                new Ui\Listing([
                    'items' => [
                        $listing = new Ui()
                    ]
                ])
            ]
        ]));
        $page->addBreadcrumb()->setItems([
            '<span class="icon white_arrow"></span><span class="text">Панель управления</span>'
        ]);

        switch ($_GET['from'] ?? 'all') {
            case 'editor';
                $tabs->addItem(new Ui\Table([
                    'items' => [
                        $table = new Ui([
                            'items' => [
                                new Ui\Td([
                                    'style' => 'padding: 0 5px; width: 25%',
                                    'items' => [
                                        new Ui\Tab([
                                            'items' => [
                                                new Ui\Content([
                                                    'url' => new Url(null, [
                                                        'from' => 'all'
                                                    ]),
                                                    'items' => [
                                                        new Ui\Item([
                                                            'items' => [
                                                                '<span class="title">Общие</span>'
                                                            ]
                                                        ])
                                                    ]
                                                ])
                                            ]
                                        ])
                                    ]
                                ]),
                                new Ui\Td([
                                    'style' => 'padding: 0 5px; width: 25%',
                                    'items' => [
                                        new Ui\Tab([
                                            'active' => true,
                                            'items' => [
                                                new Ui\Content([
                                                    'items' => [
                                                        new Ui\Item([
                                                            'items' => [
                                                                '<span class="title">Редактор</span>'
                                                            ]
                                                        ])
                                                    ]
                                                ])
                                            ]
                                        ])
                                    ]
                                ])
                            ]
                        ])
                    ]
                ]));
                $listing->addItem(new Ui\Content([
                    'url' => '/panel/items',
                    'items' => [
                        new Ui\Item([
                            'items' => [
                                'Предметы'
                            ]
                        ])
                    ]
                ]));
                break;
            case 'all';
            default;
                $tabs->addItem(new Ui\Table([
                    'items' => [
                        $table = new Ui([
                            'items' => [
                                new Ui\Td([
                                    'style' => 'padding: 0 5px; width: 25%',
                                    'items' => [
                                        new Ui\Tab([
                                            'active' => true,
                                            'items' => [
                                                new Ui\Content([
                                                    'items' => [
                                                        new Ui\Item([
                                                            'items' => [
                                                                '<span class="title">Общие</span>'
                                                            ]
                                                        ])
                                                    ]
                                                ])
                                            ]
                                        ])
                                    ]
                                ]),
                                new Ui\Td([
                                    'style' => 'padding: 0 5px; width: 25%',
                                    'items' => [
                                        new Ui\Tab([
                                            'items' => [
                                                new Ui\Content([
                                                    'url' => new Url(null, [
                                                        'from' => 'editor'
                                                    ]),
                                                    'items' => [
                                                        new Ui\Item([
                                                            'items' => [
                                                                '<span class="title">Редактор</span>'
                                                            ]
                                                        ])
                                                    ]
                                                ])
                                            ]
                                        ])
                                    ]
                                ])
                            ]
                        ])
                    ]
                ]));
                $listing->addItem(new Ui\Content([
                    'items' => [
                        new Ui\Item([
                            'items' => [
                                'Системные настройки'
                            ]
                        ])
                    ]
                ]));
                break;
        }

        return $page;
    });

    (new Module([
        'router' => $router,
        'page' => $page,
        'request' => $request,
        'panel' => $panel
    ]))->bind(...[
        __DIR__ . '/*/module.php'
    ]);
}
