<?php
/**
 * @var \core\Module $this
 * @var \core\Router $router
 * @var \core\Request $request
 * @var \core\ui\Page $page
 * @var \core\router\Group $panel
 */

use core\Ui;
use core\Url;
use core\Response;

// Предметы
$items = $panel->addGroup('/items', function () use ($page, $request) {

    $page->setTitle('Предметы - Общие');
    $page->addBreadcrumb()->setUrl(new Url('/panel', ['from' => 'editor']))->setItems([
        '<span class="icon white_arrow"></span><span class="text">Панель управления</span>'
    ]);
    $page->addBreadcrumb()->setItems([
        '<span class="icon white_arrow"></span><span class="text">Предметы</span>'
    ]);

    $page_content = $page->addUiContent()->setItems([
        $ui_messages = new Ui(),
    ]);
    $listing = $page_content->addUiItem()->addUiListing();

    if ($data_items = Core::getList('items')) {
        foreach ($data_items AS $data_item) {
            $item = new system\Item($data_item);

            $listing_content = $listing->addUiContent();
            $listing_content->setUrl(new Url('/panel/item', ['id' => $item->id]));
            $table = $listing_content->addUiTable();
            $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
                'path' => '/images/items/' . $item->icon,
                'count' => $item->count
            ]));
            $table->addUiTd()->setStyle('width: 100%')->addUiItem()->addItem($item->title);
        }
    }
    if (!$data_items) {
        $listing_content = $listing->addUiContent();
        $listing_content->addUiItem()->addItem('Предметы остуствует');
    }

    $page_content->addItem(new Ui\Item([
        'items' => [
            new Ui\Button([
                'url' => '/panel/items/add',
                'items' => [
                    'Создать предмет'
                ]
            ])
        ]
    ]));
    foreach (\Flash::getMessages() AS $message) {
        $ui_messages->addItem(new Ui\Message([
            'type' => $message['type'],
            'items' => [
                new Ui\Item([
                    'items' => [
                        $message['text']
                    ]
                ])
            ]
        ]));
    }

    return $page;
});
$items->addRoute('/add', function () use ($page, $request) {
    if ($request->isMethodPost()) {
        $title = \Text::toValue(filter_input(INPUT_POST, 'title', FILTER_SANITIZE_STRING));
        \Flash::addInput('title', $title);

        if (!$title) {
            \Flash::addMessageError('Ведите название предмета');
        } else {
            $res = Core::getConnection()->prepare("INSERT INTO `system_items` (`title`) VALUES (?)");
            $res->bindParam(1, $title, PDO::PARAM_STR);
            $res->execute();
            \Flash::addMessageSuccess(sprintf('Предмет "%s" успешно создан', $title));
            return new Response\Redirect([
                'url' => '/panel/items'
            ]);
        }

        return new Response\Redirect([
            'url' => $request->getUri()
        ]);
    }

    $page->setTitle('Предметы - Создать предмет');
    $page->addBreadcrumb()->setUrl(new Url('/panel', ['from' => 'editor']))->setItems([
        '<span class="icon white_arrow"></span><span class="text">Панель управления</span>'
    ]);
    $page->addBreadcrumb()->setUrl('/panel/items')->setItems([
        '<span class="icon white_arrow"></span><span class="text">Предметы</span>'
    ]);
    $page->addBreadcrumb()->setItems([
        '<span class="icon white_arrow"></span><span class="text">Создать предмет</span>'
    ]);

    $page_content = $page->addUiContent();
    $listing = $page_content->addUiItem()->addUiListing();

    $listing->addUiContent()->setItems([
        $ui_messages = new Ui(),
        new Ui\Form([
            'items' => [
                new Ui\Item([
                    'items' => [
                        new Ui\Input\Text([
                            'name' => 'title',
                            'placeholder' => 'Название предмета',
                            'value' => \Flash::getInput('title')
                        ])
                    ]
                ]),
                new Ui\Item([
                    'items' => [
                        new Ui\Input\Submit([
                            'value' => 'Создать предмет'
                        ])
                    ]
                ])
            ]
        ])
    ]);
    foreach (\Flash::getMessages() AS $message) {
        $ui_messages->addItem(new Ui\Message([
            'type' => $message['type'],
            'items' => [
                new Ui\Item([
                    'items' => [
                        $message['text']
                    ]
                ])
            ]
        ]));
    }

    return $page;
})->setMethods('GET', 'POST');

// Предмет
$item = $panel->addGroup('/item', function () use ($page, $request) {
    if (!$item = Core::findSystemItem(filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT))) {
        return new Response\Redirect([
            'url' => '/panel/items'
        ]);
    }

    $page->setTitle(sprintf('Предмет - %s', $item->title));
    $page->addBreadcrumb()->setUrl(new Url('/panel', ['from' => 'editor']))->setItems([
        '<span class="icon white_arrow"></span><span class="text">Панель управления</span>'
    ]);
    $page->addBreadcrumb()->setUrl('/panel/items')->setItems([
        '<span class="icon white_arrow"></span><span class="text">Предметы</span>'
    ]);
    $page->addBreadcrumb()->setItems([
        '<span class="icon white_arrow"></span><span class="text">' . sprintf('Предмет - %s', $item->title) . '</span>'
    ]);

    $page_content = $page->addUiContent()->setItems([
        $ui_messages = new Ui(),
    ]);
    $listing = $page_content->addUiItem()->addUiListing();

    $listing_content = $listing->addUiContent();
    $table = $listing_content->addUiTable();
    $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
        'path' => '/images/items/' . $item->icon,
        'count' => $item->count
    ]));
    $table->addUiTd()->setStyle('width: 100%')->addUiItem()->addItem($item->title);

    $page_content->addItem(new Ui\Item([
        'items' => [
            new Ui\Button([
                'url' => new Url('/panel/item/edit', ['id' => $item->id]),
                'items' => [
                    'Редактировать предмет'
                ]
            ])
        ]
    ]));
    $page_content->addItem(new Ui\Item([
        'items' => [
            new Ui\Button([
                'url' => new Url('/panel/item/delete', ['id' => $item->id]),
                'items' => [
                    'Удалить предмет'
                ]
            ])
        ]
    ]));

    return $page;
});
$item->addRoute('/edit', function () use ($page, $request) {
    if (!$item = Core::findSystemItem(filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT))) {
        return new Response\Redirect([
            'url' => '/panel/items'
        ]);
    }

    return $page;
});
$item->addRoute('/delete', function () use ($page, $request) {
    if (!$item = Core::findSystemItem(filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT))) {
        return new Response\Redirect([
            'url' => '/panel/items'
        ]);
    }

    return $page;
});