<?php
/**
 * @var \core\Module $this
 * @var \core\Router $router
 * @var \core\Request $request
 * @var \core\ui\Page $page
 */

use core\Ui;
use core\Response;

if (!User::isAuth()) {
    if (!$request->isHome()) {
        $page->addBreadcrumb()->setUrl('/')->setItems([
            '<span class="icon white_home"></span><span class="text">Авторизация</span>'
        ]);
    }

    $router->addRoute('/', function () use ($page, $request) {
        if ($request->isMethodPost()) {
            $login = \Text::toValue(filter_input(INPUT_POST, 'login', FILTER_SANITIZE_STRING));
            $password = \Text::toValue(filter_input(INPUT_POST, 'password', FILTER_SANITIZE_STRING));

            \Flash::addInput('login', $login);
            \Flash::addInput('password', $password);

            if(!$login) {
                Flash::addMessageError('Ведите лонин');
            } elseif(!$password) {
                Flash::addMessageError('Ведите пароль');
            } elseif (\User::authAccount($login, $password)) {
                return new Response\Redirect([
                    'url' => '/account'
                ]);
            }

            return new Response\Redirect([
                'url' => $request->getUrl()
            ]);
        }

        $page->setTitle('Авторизация');
        $page->addItem('<a href="/" class="model"><img class="logo" src="/images/logo.png"/></a>');
        $page->addUiContent()->setItems([
            new Ui\Item([
                'items' => [
                    $formAuth = new Ui\Listing([
                        'items' => [
                            new Ui\Content([
                                'items' => [
                                    $ui_messages = new Ui(),
                                    new Ui\Form([
                                        'items' => [
                                            new Ui\Item([
                                                'items' => [
                                                    new Ui\Input\Text([
                                                        'name' => 'login',
                                                        'placeholder' => 'Логин',
                                                        'value' => \Flash::getInput('login')
                                                    ])
                                                ]
                                            ]),
                                            new Ui\Item([
                                                'items' => [
                                                    new Ui\Input\Password([
                                                        'name' => 'password',
                                                        'placeholder' => 'Пароль',
                                                        'value' => \Flash::getInput('password')
                                                    ])
                                                ]
                                            ]),
                                            new Ui\Item([
                                                'items' => [
                                                    new Ui\Input\Submit([
                                                        'value' => 'Войди'
                                                    ])
                                                ]
                                            ]),
                                            new Ui\Item([
                                                'items' => [
                                                    new Ui\Button([
                                                        'url' => '/start',
                                                        'items' => [
                                                            'Начать игру'
                                                        ]
                                                    ])
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ])
                ]
            ])
        ]);

        foreach (\Flash::getMessages() AS $message) {
            $ui_messages->addItem(new Ui\Message([
                'type' => $message['type'],
                'items' => [
                    new Ui\Item([
                        'items' => [
                            $message['text']
                        ]
                    ])
                ]
            ]));
        }
        return $page;
    })->setMethods('GET', 'POST');
    $router->addRoute('/start', function () use ($page, $request) {
        if ($request->isMethodPost()) {
            $login = \Text::toValue(filter_input(INPUT_POST, 'login', FILTER_SANITIZE_STRING));
            $password = \Text::toValue(filter_input(INPUT_POST, 'password', FILTER_SANITIZE_STRING));
            $confirm_password = \Text::toValue(filter_input(INPUT_POST, 'confirm_password', FILTER_SANITIZE_STRING));
            $email = \Text::toValue(filter_input(INPUT_POST, 'email', FILTER_SANITIZE_STRING));

            \Flash::addInput('login', $login);
            \Flash::addInput('password', $password);
            \Flash::addInput('confirm_password', $confirm_password);
            \Flash::addInput('email', $email);

            if(!$login) {
                Flash::addMessageError('Ведите лонин');
            } elseif(!$password) {
                Flash::addMessageError('Ведите пароль');
            } elseif ($password != $confirm_password) {
                \Flash::addMessageError('Подверждение пароля веден не верно');
            } elseif (\User::newAccount($login, $password)) {
                return new Response\Redirect([
                    'url' => '/'
                ]);
            }

            return new Response\Redirect([
                'url' => $request->getUrl()
            ]);
        }

        $page->setTitle('Начать игру');
        $page->addUiContent()->setItems([
            new Ui\Item([
                'items' => [
                    new Ui\Listing([
                        'items' => [
                            new Ui\Content([
                                'items' => [
                                    new Ui\Item([
                                        'items' => [
                                            'Все ремесла в игре можно разделить по нескольким направлениям, к каждому из которых относятся несколько из них. Например, вы можете стать настоящим фермером, постоя себе дом, вырастить урожай и разводить животных. Выбор за вами.'
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ])
                ]
            ]),
            new Ui\Item([
                'items' => [
                    new Ui\Listing([
                        'items' => [
                            new Ui\Content([
                                'items' => [
                                    $ui_messages = new Ui(),
                                    new Ui\Form([
                                        'action' => $request->getUrl(),
                                        'items' => [
                                            new Ui\Item([
                                                'items' => [
                                                    new Ui\Input\Text([
                                                        'name' => 'login',
                                                        'placeholder' => 'Логин',
                                                        'value' => \Flash::getInput('login')
                                                    ])
                                                ]
                                            ]),
                                            new Ui\Item([
                                                'items' => [
                                                    new Ui\Input\Password([
                                                        'name' => 'password',
                                                        'placeholder' => 'Пароль',
                                                        'value' => \Flash::getInput('password')
                                                    ])
                                                ]
                                            ]),
                                            new Ui\Item([
                                                'items' => [
                                                    new Ui\Input\Password([
                                                        'name' => 'confirm_password',
                                                        'placeholder' => 'Подверждение пароля',
                                                        'value' => \Flash::getInput('confirm_password')
                                                    ])
                                                ]
                                            ]),
                                            new Ui\Item([
                                                'items' => [
                                                    new Ui\Input\Email([
                                                        'name' => 'email',
                                                        'placeholder' => 'Электроная почта',
                                                        'value' => \Flash::getInput('email')
                                                    ])
                                                ]
                                            ]),
                                            new Ui\Item([
                                                'items' => [
                                                    new Ui\Input\Submit([
                                                        'value' => 'Создать аккаунт'
                                                    ])
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ])
                ]
            ])
        ]);
        $page->addBreadcrumb()->setItems([
            '<span class="icon white_arrow"></span><span class="text">Начать игру</span>'
        ]);

        foreach (\Flash::getMessages() AS $message) {
            $ui_messages->addItem(new Ui\Message([
                'type' => $message['type'],
                'items' => [
                    new Ui\Item([
                        'items' => [
                            $message['text']
                        ]
                    ])
                ]
            ]));
        }
        return $page;
    })->setMethods('GET', 'POST');
}
if (User::isAuth()) {
    if (!$request->isHome()) {
        $page->addBreadcrumb()->setUrl('/')->setItems([
            '<span class="icon white_home"></span><span class="text">Город</span>'
        ]);
    }

    User::getAccount()->getEvent()->onCheckLevel(User::getAccount()->getExpProgress()->getLevel());
    User::getAccount()->getEvent()->onCheckAccount(time() - User::getAccount()->data_register);

    $this->bind(...[
        __DIR__ . '/*/module.php'
    ]);
}

// Правила
$page->addMenu('foot_menu', [
    'url' => '/rules',
    'title' => 'Правила'
]);
$rules = $router->addGroup('/rules', function () use ($page) {
    $page->setTitle('Правила');
    $page->setItems([
        $content = new Ui\Content([
            'items' => [
                new Ui\Item([
                    'items' => [
                        $listing = new Ui\Listing()
                    ]
                ])
            ]
        ])
    ]);


    $page->addBreadcrumb([
        'items' => [
            '<span class="icon white_arrow"></span><span class="text">Правила</span>'
        ]
    ]);

    $listing->addItem(new Ui\Content([
        'items' => [
            new Ui\Item([
                'items' => [
                    '<div><b>1. Общие положения.</b></div>',
                ]
            ]),
            new Ui\Item([
                'items' => [
                    '<div><b>1.1.</b> Настоящее Пользовательское соглашение (далее «Соглашение») регламентирует порядок и условия предоставления услуг сайтом Magic.Craft, именуемой далее по тексту «Организатор», и адресовано физическому лицу, желающему получать услуги указанного сайта (далее «Участник».)</div>',
                ]
            ]),
            new Ui\Item([
                'items' => [
                    '<div><b>1.2.</b> Для начала получения услуг участник явно, полно и безоговорочно принимает все условия настоящего Соглашения, и, если Вы не согласны с каким-либо условием соглашения, Организатор предлагает вам отказаться от использования его услуг.</div>',
                ]
            ]),
            new Ui\Item([
                'items' => [
                    '<div><b>1.3.</b> Организатор и участник признают порядок и форму заключения настоящего соглашения равнозначным по юридической силе соглашению, заключенному в письменной форме.</div>',
                ]
            ]),
            new Ui\Item([
                'items' => [
                    '<div><b>1.4.</b> Администрация Chickens-farm.biz оставляет за собой право вносить любые изменения и дополнения в Пользовательское соглашение и на сайте, без предупреждения пользователей.</div>'
                ]
            ])
        ]
    ]));

    return $page;
});

// Информация
$page->addMenu('foot_menu', [
    'url' => '/info',
    'title' => 'Информация'
]);
$info = $router->addGroup('/info', function () use ($page) {
    $page->setTitle('Информация');
    $page->setItems([
        $content = new Ui\Content([
            'items' => [
                new Ui\Item([
                    'items' => [
                        $listing = new Ui\Listing()
                    ]
                ])
            ]
        ])
    ]);

    $page->addBreadcrumb([
        'items' => [
            '<span class="icon white_arrow"></span><span class="text">Информация</span>'
        ]
    ]);

    $listing->addItem(new Ui\Content([
        'items' => [
            new Ui\Item([
                'items' => [
                    '<div><b>О ПРОЕКТЕ</b></div>'
                ]
            ]),
            new Ui\Item([
                'items' => [
                    '<div>Игра <b>Craft-Free.Ru</b> уникальная игровая площадка для развлечений и заработка в интернете. В нашей игре каждый пользователь может зарабатывать реальные деньги игровым путем. Красочный и понятный интерфейс доступен каждому пользователю. Регистрируйтесь и начинайте зарабатывать реальные деньги уже сегодня!</div>',
                ]
            ])
        ]
    ]));
    $listing->addItem(new Ui\Content([
        'items' => [
            new Ui\Item([
                'items' => [
                    '<div><b>НАШИ ГАРАНТИИ</b></div>'
                ]
            ]),
            new Ui\Item([
                'items' => [
                    '<div>Ваши деньги хранятся на счетах проекта в разных платежных системах.</div>',
                    '<div>Максимально быстрые выплаты денег на Ваш кошелек!</div>',
                    '<div>Полное отсутствие подводных камней! Всё так, как есть! Полностью прозрачная система, работающая для Вас!</div>',
                    '<div>Мониторинги наблюдающие за работоспособностью проекта</div>'
                ]
            ])
        ]
    ]));
    $listing->addItem(new Ui\Content([
        'items' => [
            new Ui\Item([
                'items' => [
                    '<div><b>ОБСЛУЖИВАНИЕ</b></div>'
                ]
            ]),
            new Ui\Item([
                'items' => [
                    '<div>Наша команда тех. поддержки готова ответить на любой интересующий вас вопрос по поводу проекта. Время обработки вашей заявки составляет от 5-и минут до 24 часов с момента подачи заявки. Служба поддержки работает 24 часа в сутки 7 дней в неделю.</div>'
                ]
            ])
        ]
    ]));
    $listing->addItem(new Ui\Content([
        'url' => '/info/faq',
        'items' => [
            new Ui\Item([
                'items' => [
                    '<div style="text-align: center">Ответы на вопросы</div>'
                ]
            ])
        ]
    ]));

    return $page;
});
$info->addRoute('/faq', function () use ($page) {
    $page->setTitle('Информация - Ответы на вопросы');
    $page->setItems([
        $content = new Ui\Content([
            'items' => [
                new Ui\Item([
                    'items' => [
                        $listing = new Ui\Listing()
                    ]
                ])
            ]
        ])
    ]);

    $page->addBreadcrumb([
        'url' => '/info',
        'items' => [
            '<span class="icon white_arrow"></span><span class="text">Информация</span>'
        ]
    ]);
    $page->addBreadcrumb([
        'items' => [
            '<span class="icon white_arrow"></span><span class="text">Ответы на вопросы</span>'
        ]
    ]);

    return $page;
});