<?php
/**
 * @var \core\Module $this
 * @var \core\Router $router
 * @var \core\Request $request
 * @var \core\ui\Page $page
 */

use core\Response;
use core\Url;
use core\Ui;

$router->addRoute('/', function () use ($page) {
    if (isset($_GET['event'])) {
        if (!$event = Core::findEvent(filter_input(INPUT_GET, 'event', FILTER_SANITIZE_NUMBER_INT))) {
            return new Response\Redirect([
                'url' => (new Url())->removeParam('event')
            ]);
        }

        return Event::findComponent($event['name'])->execute($event, $page);
    }
    if (isset($_GET['npc'])) {
        if (!$npc = Core::findNpc(filter_input(INPUT_GET, 'npc', FILTER_SANITIZE_NUMBER_INT))) {
            return new Response\Redirect([
                'url' => (new Url())->removeParam('npc')
            ]);
        }

        return Npc::findComponent($npc->name)->execute($npc, $page);
    }

    $page->setTitle('Город');
    $page->setItems([
        '<a href="/" class="model"><img class="logo" src="/images/city.png"/></a>',
        $content = new Ui\Content()
    ]);

    if ($buildings = Core::getBuildings()) {
        $listing = $content->addUiItem()->addUiListing();

        foreach ($buildings AS $building) {
            if (!Building::isComponent($building->name)) {
                continue;
            }

            $config = \Building::findConfig($building->name);

            $listing->addItem(new Ui\Content([
                'url' => new Url($config['name']),
                'items' => [
                    new Ui\Item([
                        'items' => [
                            $config['title']
                        ]
                    ])
                ]
            ]));
        }
    }
    if ($events = Core::getEvents()) {
        $listing = $content->addUiItem()->addUiListing();

        foreach ($events AS $event) {
            if (!Event::isComponent($event['name'])) {
                continue;
            }

            $config = Event::findConfig($event['name']);
            $listing->addItem(new Ui\Content([
                'url' => new Url(null, [
                    'event' => $event['id']
                ]),
                'items' => [
                    new Ui\Item([
                        'items' => [
                            '[Ивент] ' . $config['title'],
                            '<span style="float: right">' . when($event['time_end']) .'</span>'
                        ]
                    ])
                ]
            ]));
        }
    }
    if ($npcs = Core::getNpcs()) {
        $listing = $content->addUiItem()->addUiListing();

        foreach ($npcs AS $npc) {
            if (!Npc::isComponent($npc->name)) {
                continue;
            }

            $config = Npc::findConfig($npc->name);
            $listing->addItem(new Ui\Content([
                'url' => new Url(null, [
                    'npc' => $npc->id
                ]),
                'items' => [
                    new Ui\Table([
                        'items' => [
                            new Ui\Td([
                                'items' => [
                                    new Ui\Item([
                                        'items' => [
                                            new Ui\Image([
                                                'class' => $config['icon'],
                                            ])
                                        ]
                                    ])
                                ]
                            ]),
                            new Ui\Td([
                                'style' => 'width: 100%',
                                'items' => [
                                    new Ui\Item([
                                        'items' => [
                                            $config['title']
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ])
                ]
            ]));
        }
    }

    return $page;
});
$building = $router->addGroup('/{name}', function ($name) use ($page) {
    if (!$building = Core::findBuilding($name)) {
        return false;
    }
    return Building::findComponent($building->name)->execute($building, $page);
});
