<?php
/**
 * @var \core\Module $this
 * @var \core\Router $router
 * @var \core\Request $request
 * @var \core\ui\Page $page
 */

use core\Module;
use core\Ui;
use core\Url;
use core\Response;

$account = $router->addGroup('/account', function () use ($page) {
    $page->setTitle('Аккаунт');
    $page->setItems([
        $content = new Ui\Content([
            'items' => [
                $ui = new Ui()
            ]
        ])
    ]);
    $ui->addItem(new Ui\Item([
        'items' => [
            $item = new Ui([
                'items' => [
                    $tabs = new Ui(),
                    new Ui\Listing([
                        'items' => [
                            $listing = new Ui()
                        ]
                    ])
                ]
            ])
        ]
    ]));
    $page->addBreadcrumb([
        'items' => [
            '<span class="icon white_arrow"></span><span class="text">Аккаунт</span>'
        ]
    ]);

    switch ($_GET['from'] ?? 'info') {
        case 'menu';
            $tabs->addItem(new Ui\Table([
                'items' => [
                    $table = new Ui([
                        'items' => [
                            new Ui\Td([
                                'style' => 'padding: 0 5px; width: 25%',
                                'items' => [
                                    new Ui\Tab([
                                        'items' => [
                                            new Ui\Content([
                                                'url' => new Url(null, [
                                                    'from' => 'info'
                                                ]),
                                                'items' => [
                                                    new Ui\Item([
                                                        'items' => [
                                                            '<span class="title">Информация</span>'
                                                        ]
                                                    ])
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ]),
                            new Ui\Td([
                                'style' => 'padding: 0 5px; width: 25%',
                                'items' => [
                                    new Ui\Tab([
                                        'active' => true,
                                        'items' => [
                                            new Ui\Content([
                                                'items' => [
                                                    new Ui\Item([
                                                        'items' => [
                                                            '<span class="title">Меню</span>'
                                                        ]
                                                    ])
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ])
                ]
            ]));
            $listing->addItem(new Ui\Content([
                'url' => '/account/craft',
                'items' => [
                    new Ui\Item([
                        'items' => [
                            'Ремесло'
                        ]
                    ])
                ]
            ]));
            $listing->addItem(new Ui\Content([
                'url' => '/account/inventory',
                'items' => [
                    new Ui\Item([
                        'items' => [
                            'Сумка'
                        ]
                    ])
                ]
            ]));
            $listing->addItem(new Ui\Content([
                'url' => '/account/quests',
                'items' => [
                    new Ui\Item([
                        'items' => [
                            'Задания'
                        ]
                    ])
                ]
            ]));
            $listing->addItem(new Ui\Content([
                'url' => '/account/achievements',
                'items' => [
                    new Ui\Item([
                        'items' => [
                            'Достижения'
                        ]
                    ])
                ]
            ]));
            $listing->addItem(new Ui\Content([
                'url' => '/account/farm',
                'items' => [
                    new Ui\Item([
                        'items' => [
                            'Ферма'
                        ]
                    ])
                ]
            ]));
            break;
        case 'info';
        default;
            $data_register = User::getAccount()->data_register;
            $life_account = time() - $data_register;
            $tabs->addItem(new Ui\Table([
                'items' => [
                    $table = new Ui([
                        'items' => [
                            new Ui\Td([
                                'style' => 'padding: 0 5px; width: 25%',
                                'items' => [
                                    new Ui\Tab([
                                        'active' => true,
                                        'items' => [
                                            new Ui\Content([
                                                'items' => [
                                                    new Ui\Item([
                                                        'items' => [
                                                            '<span class="title">Информация</span>'
                                                        ]
                                                    ])
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ]),
                            new Ui\Td([
                                'style' => 'padding: 0 5px; width: 25%',
                                'items' => [
                                    new Ui\Tab([
                                        'items' => [
                                            new Ui\Content([
                                                'url' => new Url(null, [
                                                    'from' => 'menu'
                                                ]),
                                                'items' => [
                                                    new Ui\Item([
                                                        'items' => [
                                                            '<span class="title">Меню</span>'
                                                        ]
                                                    ])
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ])
                ]
            ]));
            $listing->addItem(new Ui\Content([
                'items' => [
                    new Ui\Item([
                        'items' => [
                            '<div><b>АККАУНТ</b></div>'
                        ]
                    ]),
                    new Ui\Item([
                        'items' => [
                            sprintf('<div>Логин: %s</div>', \User::getAccount()->login)
                        ]
                    ]),
                    new Ui\Item([
                        'items' => [
                            sprintf('<div>Дата регистрации: %s</div>', when($data_register))
                        ]
                    ]),
                    new Ui\Item([
                        'items' => [
                            sprintf('<div>На проекте: %s</div>', when($life_account, true))
                        ]
                    ])
                ]
            ]));
            $listing->addItem(new Ui\Content([
                'items' => [
                    new Ui\Item([
                        'items' => [
                            '<div><b>ХАРАКТЕРИСТИКИ</b></div>'
                        ]
                    ]),
                    new Ui\Table([
                        'items' => [
                            new Ui\Td([
                                'items' => [
                                    new Ui\Item([
                                        'items' => [
                                            '<img class="icon box" src="/images/icons/10/level.png">'
                                        ]
                                    ])
                                ]
                            ]),
                            new Ui\Td([
                                'style' => 'width: 100%',
                                'items' => [
                                    new Ui\Item([
                                        'items' => [
                                            sprintf('<span>Уровень: %s</span>',
                                                \User::getAccount()->getExpProgress()->getLevel())
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ]),
                    new Ui\Table([
                        'items' => [
                            new Ui\Td([
                                'items' => [
                                    new Ui\Item([
                                        'items' => [
                                            '<img class="icon box" src="/images/icons/10/exp.png">'
                                        ]
                                    ])
                                ]
                            ]),
                            new Ui\Td([
                                'style' => 'width: 100%',
                                'items' => [
                                    new Ui\Item([
                                        'items' => [
                                            sprintf('<span>Опыт: %s / %s</span>',
                                                \User::getAccount()->getExpProgress()->getExp(),
                                                \User::getAccount()->getExpProgress()->getMaxExp()
                                            )
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ]),
                    new Ui\Table([
                        'items' => [
                            new Ui\Td([
                                'items' => [
                                    new Ui\Item([
                                        'items' => [
                                            '<img class="icon box" src="/images/icons/miner.png">'
                                        ]
                                    ])
                                ]
                            ]),
                            new Ui\Td([
                                'style' => 'width: 100%',
                                'items' => [
                                    new Ui\Item([
                                        'items' => [
                                            sprintf('<span>Очки работы: %s / %s</span>',
                                                \User::getAccount()->getEnergyProgress()->getEnergy(),
                                                \User::getAccount()->getEnergyProgress()->getMaxEnergy()
                                            )
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ]),
                    new Ui\Table([
                        'items' => [
                            new Ui\Td([
                                'items' => [
                                    new Ui\Item([
                                        'items' => [
                                            '<img class="icon box" src="/images/icons/16/plant.png">'
                                        ]
                                    ])
                                ]
                            ]),
                            new Ui\Td([
                                'style' => 'width: 100%',
                                'items' => [
                                    new Ui\Item([
                                        'items' => [
                                            sprintf('<span>Ремесленная репутация: %s</span>',
                                                \User::getAccount()->craft_reputation
                                            )
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ])
                ]
            ]));
            $listing->addItem(new Ui\Content([
                'items' => [
                    new Ui\Item([
                        'items' => [
                            '<div class="title"><b>Эффекты</b></div>'
                        ]
                    ]),
                    new Ui\Table([
                        'items' => [
                            new Ui\Td([
                                'items' => [
                                    new Ui\Item([
                                        'items' => [
                                            '<img class="icon box" src="/images/icons/10/exp.png">'
                                        ]
                                    ])
                                ]
                            ]),
                            new Ui\Td([
                                'style' => 'width: 100%',
                                'items' => [
                                    new Ui\Item([
                                        'items' => [
                                            sprintf('<span>Получаемый опыт: %s%%</span>',
                                               Effect::findComponent('exp')->getPercent())
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ]),
                    new Ui\Table([
                        'items' => [
                            new Ui\Td([
                                'items' => [
                                    new Ui\Item([
                                        'items' => [
                                            '<img class="icon box" src="/images/icons/10/exp.png">'
                                        ]
                                    ])
                                ]
                            ]),
                            new Ui\Td([
                                'style' => 'width: 100%',
                                'items' => [
                                    new Ui\Item([
                                        'items' => [
                                            sprintf('<span>Получаемый ремесленый опыт: %s%%</span>',
                                                Effect::findComponent('craft_exp')->getPercent())
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ]),
                    new Ui\Table([
                        'items' => [
                            new Ui\Td([
                                'items' => [
                                    new Ui\Item([
                                        'items' => [
                                            '<img class="icon box" src="/images/icons/16/plant.png">'
                                        ]
                                    ])
                                ]
                            ]),
                            new Ui\Td([
                                'style' => 'width: 100%',
                                'items' => [
                                    new Ui\Item([
                                        'items' => [
                                            sprintf('<span>Получаемый ремесленая репутация: %s%%</span>',
                                                Effect::findComponent('craft_reputation')->getPercent())
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ])
                ]
            ]));
            break;
    }

    $content->addItem(new Ui\Item([
        'items' => [
            new Ui\Button([
                'url' => '/account/exit',
                'items' => [
                    'Выход'
                ]
            ])
        ]
    ]));

    return $page;
});
$account->addRoute('/exit', function () {
    \User::exitAccount();

    return new Response\Redirect([
        'url' => '/'
    ]);
});

(new Module([
    'router' => $router,
    'page' => $page,
    'request' => $request,
    'account' => $account
]))->bind(...[
    __DIR__ . '/*/module.php'
]);