<?php
/**
 * @var \core\Module $this
 * @var \core\Router $router
 * @var \core\Request $request
 * @var \core\ui\Page $page
 * @var \core\router\Group $account
 */

use core\Url;
use core\Ui;
use core\Response;


$res = \Core::getConnection()->prepare("SELECT COUNT(*)
            FROM `inventory_items` 
            LEFT JOIN `items` ON `items`.`id` = `inventory_items`.`item_id` 
            WHERE `inventory_items`.`account_id` = ? 
              AND `inventory_items`.count = `items`.`count` 
              AND `inventory_items`.type = 0 
            GROUP BY `item_id`");
$res->execute([User::getAccount()->id]);
$count = $res->fetchColumn();

$page->addMenu('account_menu', [
    'title' => 'Инвентарь',
    'icon' => 'inventory',
    'url' => '/account/inventory',
    'count' => $count
], 4);
$inventory = $account->addGroup('/inventory', function () use ($page) {
    $page->setTitle('Ремесло');
    $page->addBreadcrumb()->setUrl('/account')->setItems([
        '<span class="icon white_arrow"></span><span class="text">Аккаунт</span>'
    ]);
    $page->addBreadcrumb()->setItems([
        '<span class="icon white_arrow"></span><span class="text">Ремесло</span>'
    ]);

    // Основное страница контент
    $page_content = $page->addUiContent()->setItems([
        $ui_messages = new Ui()
    ]);

    // Листинг с таб
    $listing = $page_content->addUiItem()->setItems([
        $tabs = new Ui\Table()
    ])->addUiListing();

    switch ($_GET['from'] ?? 'inventory') {
        case 'cube';
            $tabs->addItem(new Ui([
                'items' => [
                    new Ui\Td([
                        'style' => 'padding: 0 5px; width: 25%',
                        'items' => [
                            new Ui\Tab([
                                'items' => [
                                    new Ui\Content([
                                        'url' => new Url(null, [
                                            'from' => 'inventory'
                                        ]),
                                        'items' => [
                                            new Ui\Item([
                                                'items' => [
                                                    '<span class="title">Инвентарь</span>'
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ]),
                    new Ui\Td([
                        'style' => 'padding: 0 5px; width: 25%',
                        'items' => [
                            new Ui\Tab([
                                'active' => true,
                                'items' => [
                                    new Ui\Content([
                                        'items' => [
                                            new Ui\Item([
                                                'items' => [
                                                    '<span class="title">Куб</span>'
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ])
                ]
            ]));

            $items = User::getAccount()->getInventory()->getItems(true);
            $count_items = count($items);
            $max_items =  max(\User::getAccount()->slot_inventory, $count_items);

            for ($i = 0; $i < $max_items; $i++) {
                $data = array_shift($items);
                if ($data) {
                    $system_item = Core::findItem($data['item_id']);
                    $listing_content = $listing->addUiContent();
                    $listing_content->setUrl(new Url('/account/inventory/item', ['id' => $data['id']]));
                    $table = $listing_content->addUiTable();
                    $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
                        'style' => 'width: 40px;',
                        'path' => '/images/items/' . $system_item->icon,
                        'count' => $data['count']
                    ]));

                    $td = $table->addUiTd();
                    $td->setStyle('width: 100%');

                    $td->addUiItem()->addItem($system_item->title . ' ' .
                        ($data['count'] == $system_item->count ? '[Максимум]' : null) . ' ' .
                        ($data['type'] == 1 ? '[Подарок]' : null) . ' ' .
                        ($data['type'] == 2 ? '[Квест]' : null)
                    );
                } else {
                    $listing_content = $listing->addUiContent();
                    $table = $listing_content->addUiTable();
                    $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
                        'style' => 'width: 40px;',
                        'path' => '/images/not_slot.png'
                    ]));

                    $td = $table->addUiTd();
                    $td->setStyle('width: 100%')->addUiItem()->addItem('Свободный слот');
                }
            }

            break;
        default;
        case 'inventory';
            $tabs->addItem(new Ui([
                'items' => [
                    new Ui\Td([
                        'style' => 'padding: 0 5px; width: 25%',
                        'items' => [
                            new Ui\Tab([
                                'active' => true,
                                'items' => [
                                    new Ui\Content([
                                        'items' => [
                                            new Ui\Item([
                                                'items' => [
                                                    '<span class="title">Инвентарь</span>'
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ]),
                    new Ui\Td([
                        'style' => 'padding: 0 5px; width: 25%',
                        'items' => [
                            new Ui\Tab([
                                'items' => [
                                    new Ui\Content([
                                        'url' => new Url(null, [
                                            'from' => 'cube'
                                        ]),
                                        'items' => [
                                            new Ui\Item([
                                                'items' => [
                                                    '<span class="title">Куб</span>'
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ])
                ]
            ]));

            $items = User::getAccount()->getInventory()->getItems();
            $count_items = count($items);
            $max_items = max(\User::getAccount()->slot_inventory, $count_items);

            for ($i = 0; $i < $max_items; $i++) {
                $data = array_shift($items);
                if ($data) {
                    $system_item = Core::findItem($data['item_id']);
                    $listing_content = $listing->addUiContent();
                    $listing_content->setUrl(new Url('/account/inventory/item', ['id' => $data['id']]));
                    $table = $listing_content->addUiTable();
                    $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
                        'style' => 'width: 40px;',
                        'path' => '/images/items/' . $system_item->icon,
                        'count' => $data['count']
                    ]));

                    $td = $table->addUiTd();
                    $td->setStyle('width: 100%');

                    $td->addUiItem()->addItem($system_item->title . ' ' .
                        ($data['count'] == $system_item->count ? '[Максимум]' : null) . ' ' .
                        ($data['type'] == 1 ? '[Подарок]' : null) . ' ' .
                        ($data['type'] == 2 ? '[Квест]' : null)
                    );
                } else {
                    $listing_content = $listing->addUiContent();
                    $table = $listing_content->addUiTable();
                    $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
                        'style' => 'width: 40px;',
                        'path' => '/images/not_slot.png'
                    ]));

                    $td = $table->addUiTd();
                    $td->setStyle('width: 100%')->addUiItem()->addItem('Свободный слот');
                }
            }

            break;
    }

    return $page;
});
$item = $inventory->addGroup('/item', function () use ($page) {
    if (!$inventory_item = User::getAccount()->getInventory()->findItem(filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT))) {
        return new Response\Redirect([
            'url' => '/account/inventory'
        ]);
    }
    if (!$item = Core::findItem($inventory_item['item_id'])) {
        return new Response\Redirect([
            'url' => '/account/inventory'
        ]);
    }

    $page->setTitle($item->title);
    $page->addBreadcrumb()->setUrl('/account')->setItems([
        '<span class="icon white_arrow"></span><span class="text">Аккаунт</span>'
    ]);
    $page->addBreadcrumb()->setUrl('/account/inventory')->setItems([
        '<span class="icon white_arrow"></span><span class="text">Инвентарь</span>'
    ]);
    $page->addBreadcrumb()->setItems([
        '<span class="icon white_arrow"></span><span class="text">' . $item->title . '</span>'
    ]);

    // Основное страница контент
    $page_content = $page->addUiContent()->setItems([
        $ui_messages = new Ui()
    ]);
    $listing = $page_content->addUiItem()->setItems([
        $tabs = new Ui()
    ])->addUiListing();

    $listing_content = $listing->addUiContent();
    $table = $listing_content->addUiTable();
    $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
        'style' => 'width: 40px;',
        'path' => '/images/items/' . $item->icon,
        'count' => $inventory_item['count']
    ]));

    $td = $table->addUiTd();
    $td->setStyle('width: 100%');
    $td->addUiItem()->setItems([
        $item->title
    ]);

    foreach (\Flash::getMessages() AS $message) {
        $ui_messages->addItem(new Ui\Message([
            'type' => $message['type'],
            'items' => [
                new Ui\Item([
                    'items' => [
                        $message['text']
                    ]
                ])
            ]
        ]));
    }
    return $page;
});