<?php
/**
 * @var \core\Module $this
 * @var \core\Router $router
 * @var \core\Request $request
 * @var \core\ui\Page $page
 * @var \core\router\Group $account
 */

use core\Ui;
use core\Url;
use core\Response;

$res = Core::getConnection()->prepare('SELECT COUNT(*) FROM craft_tasks WHERE account_id = ? AND time_end <= ?');
$res->execute([User::getAccount()->id, time()]);
$count = $res->fetchColumn();

// Ремесло
$page->addMenu('account_menu', [
    'title' => 'Ремесло',
    'icon' => 'task',
    'url' => $count ? new Url('/account/craft', [
        'from' => 'tasks'
    ]) : '/account/craft',
    'count' => $count
], 3);
$craft = $account->addGroup('/craft', function () use ($page) {
    $page->setTitle('Ремесло');
    $page->addBreadcrumb()->setUrl('/account')->setItems([
        '<span class="icon white_arrow"></span><span class="text">Аккаунт</span>'
    ]);
    $page->addBreadcrumb()->setItems([
        '<span class="icon white_arrow"></span><span class="text">Ремесло</span>'
    ]);

    // Основное страница контент
    $page_content = $page->addUiContent()->setItems([
        $ui_messages = new Ui()
    ]);

    // Листинг с таб
    $listing = $page_content->addUiItem()->setItems([
        $tabs = new Ui\Table()
    ])->addUiListing();

    switch ($_GET['from'] ?? 'professions') {
        case 'tasks';
            $tabs->addUiTd()->setStyle('padding: 0 5px; width: 25%')->addUiTab()->setItems([
                new Ui\Content([
                    'url' => new Url(null, [
                        'from' => 'professions'
                    ]),
                    'items' => [
                        new Ui\Item([
                            'items' => [
                                '<span class="title">Професии</span>'
                            ]
                        ])
                    ]
                ])
            ]);
            $tabs->addUiTd()->setStyle('padding: 0 5px; width: 25%')->addUiTab()->setActive(true)->setItems([
                new Ui\Content([
                    'items' => [
                        new Ui\Item([
                            'items' => [
                                '<span class="title">Общие задачи</span>'
                            ]
                        ])
                    ]
                ])
            ]);

            $tasks = User::getAccount()->getCraft()->getTasks();
            $count_tasks = count($tasks);
            $max_tasks = max(\User::getAccount()->slot_craft, $count_tasks);
            for ($i = 0; $i < $max_tasks; $i++) {
                $task = array_shift($tasks);
                if ($task AND
                    $recipe = Core::findRecipe($task['recipe_id']) AND
                    $recipe_item = Core::findItem($recipe->item_id)) {

                    $listing_content = $listing->addUiContent();
                    $listing_content->setUrl(new Url('/account/craft/task/pick', ['id' => $task['id']]));
                    $table = $listing_content->addUiTable();
                    $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
                        'style' => 'width: 40px;',
                        'path' => '/images/items/' . $recipe_item->icon,
                        'count' => $recipe->item_count
                    ]));

                    $td = $table->addUiTd();
                    $td->setStyle('width: 100%');

                    $td->addUiItem()->setItems([
                        ($recipe->item_count > 1 ? '[x' . $recipe->item_count . '] ' : null) .$recipe_item->title
                    ]);
                    if($task['time_end'] > time()) {
                        $td->addUiItem()->setItems([
                            sprintf('<span>Осталось: %s</span>',
                                when($task['time_end']))
                        ]);
                    } else {
                        $td->addUiItem()->setItems([
                            '<span class="time">Задача завершена!</span>'
                        ]);
                    }

                } else {
                    $listing_content = $listing->addUiContent();
                    $table = $listing_content->addUiTable();
                    $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
                        'style' => 'width: 40px;',
                        'path' => '/images/not_slot.png'
                    ]));

                    $td = $table->addUiTd();
                    $td->setStyle('width: 100%')->addUiItem()->addItem('Свободная задача');
                }
            }

            if (User::getAccount()->last_task_recipe AND
                $count_tasks < User::getAccount()->slot_craft AND
                $recipe = Core::findRecipe(User::getAccount()->last_task_recipe) AND
                $recipe_item = Core::findItem($recipe->item_id)) {

                $listing = $page_content->addUiItem()->addUiListing();
                $listing_content = $listing->addUiContent()->setItems([
                    new Ui\Item([
                        'items' => [
                            '<div><b>ПОСЛЕДНЫЙ СОЗДАНЫЙ РЕЦЕПТ</b></div>'
                        ]
                    ])
                ]);
                $table = $listing_content->addUiTable();
                $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
                    'style' => 'width: 40px;',
                    'path' => '/images/items/' . $recipe_item->icon
                ]));

                $td = $table->addUiTd();
                $td->setStyle('width: 100%');

                $td->addUiItem()->setItems([
                    $recipe_item->title
                ]);
                $td->addUiItem()->setItems([
                    sprintf('<span>Время работы: %s</span>',
                        when($recipe->life, true))
                ]);
                $listing_content->addUiItem()->addItem(new Ui\Button([
                    'url' => new Url('/account/craft/recipe/add', [
                        'id' => $recipe->id,
                        'profession' => $recipe->profession_id
                    ]),
                    'items' => [
                        'Создать'
                    ]
                ]));
            }

            break;
        case 'professions';
        default;
            $tabs->addUiTd()->setStyle('padding: 0 5px; width: 25%')->addUiTab()->setActive(true)->setItems([
                new Ui\Content([
                    'items' => [
                        new Ui\Item([
                            'items' => [
                                '<span class="title">Професии</span>'
                            ]
                        ])
                    ]
                ])
            ]);
            $tabs->addUiTd()->setStyle('padding: 0 5px; width: 25%')->addUiTab()->setItems([
                new Ui\Content([
                    'url' => new Url(null, [
                        'from' => 'tasks'
                    ]),
                    'items' => [
                        new Ui\Item([
                            'items' => [
                                '<span class="title">Общие задачи</span>'
                            ]
                        ])
                    ]
                ])
            ]);

            if ($professions = Core::getProfessions()) {
                foreach ($professions AS $profession) {
                    if (!$event_profession = User::getAccount()->getEvent()->findProfession($profession->id)) {
                        $event_profession = User::getAccount()->getEvent()->addProfession($profession->id);
                    }

                    $listing_content = $listing->addUiContent();
                    $listing_content->setUrl(new Url('/account/craft/profession', ['id' => $profession->id]));
                    $table = $listing_content->addUiTable();
                    $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
                        'style' => 'width: 52px;',
                        'path' => '/images/professions/' . $profession->icon,
                    ]));

                    $td = $table->addUiTd()->setStyle('width: 100%');
                    $td->addUiItem()->setItems([
                        '[' . $event_profession->getExpProgress()->getName() . '] ' .$profession->title
                    ]);
                    $td->addUiItem()->setItems([
                        $event_profession->exp . ' / ' . $event_profession->getExpProgress()->getAllExp()
                    ]);
                    $td->addItem($event_profession->getExpProgress());
                }
            } else {
                $listing_content = $listing->addUiContent();
                $listing_content->addUiItem()->addItem('Професии не найдено');
            }
            break;
    }

    foreach (\Flash::getMessages() AS $message) {
        $ui_messages->addItem(new Ui\Message([
            'type' => $message['type'],
            'items' => [
                $message['text']
            ]
        ]));
    }

    return $page;
});

// Задача
$task = $craft->addGroup('/task', function () use ($page) {
    if (!$task = User::getAccount()->getCraft()->findTask(filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT))) {
        return new Response\Redirect([
            'url' => new Url('/account/craft', [
                'from' => 'tasks'
            ])
        ]);
    }
    if (!$recipe = Core::findRecipe($task['recipe_id'])) {
        return new Response\Redirect([
            'url' => new Url('/account/craft', [
                'from' => 'tasks'
            ])
        ]);
    }
    if (!$recipe_item = Core::findItem($recipe->item_id)) {
        return new Response\Redirect([
            'url' => new Url('/account/craft', [
                'from' => 'tasks'
            ])
        ]);
    }

    $page->setTitle('Задача - ' . $recipe_item->title);
    $page->addBreadcrumb()->setUrl('/account')->setItems([
        '<span class="icon white_arrow"></span><span class="text">Аккаунт</span>'
    ]);
    $page->addBreadcrumb()->setUrl(new Url('/account/craft', [
        'from' => 'tasks'
    ]))->setItems([
        '<span class="icon white_arrow"></span><span class="text">Ремесло</span>'
    ]);
    $page->addBreadcrumb()->setItems([
        '<span class="icon white_arrow"></span><span class="text">Задача - ' . $recipe_item->title . '</span>'
    ]);

    // Основное страница контент
    $page_content = $page->addUiContent()->setItems([
        $ui_messages = new Ui()
    ]);
    $listing = $page_content->addUiItem()->addUiListing();

    $listing_content = $listing->addUiContent();
    $table = $listing_content->addUiTable();
    $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
        'style' => 'width: 40px;',
        'path' => '/images/items/' . $recipe_item->icon,
        'count' => $recipe->item_count
    ]));

    $td = $table->addUiTd();
    $td->setStyle('width: 100%');
    $td->addUiItem()->setItems([
        ($recipe->item_count > 1 ? '[x' . $recipe->item_count . '] ' : null) .$recipe_item->title
    ]);

    if($task['time_end'] > time()) {
        $td->addUiItem()->setItems([
            sprintf('Осталось: %s', when($task['time_end']))
        ]);
    } else {
        $td->addUiItem()->setItems([
            '<span class="time">Задача завершена!</span>'
        ]);
    }

    if (!($task['time_end'] > time())) {
        $listing_content = $listing->addUiContent();
        $listing_content->addUiItem()->addItem(new Ui\Button([
            'url' => new Url('/account/craft/task/pick', [
                'id' => $task['id'],
            ]),
            'items' => [
                'Забрать награду'
            ]
        ]));
    }

    foreach (\Flash::getMessages() AS $message) {
        $ui_messages->addItem(new Ui\Message([
            'type' => $message['type'],
            'items' => [
                new Ui\Item([
                    'items' => [
                        $message['text']
                    ]
                ])
            ]
        ]));
    }
    return $page;
});
$task->addRoute('/pick', function () {
    if (!$task = User::getAccount()->getCraft()->findTask(filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT))) {
        return new Response\Redirect([
            'url' => new Url('/account/craft', [
                'from' => 'tasks'
            ])
        ]);
    }
    if (!$recipe = Core::findRecipe($task['recipe_id'])) {
        return new Response\Redirect([
            'url' => new Url('/account/craft', [
                'from' => 'tasks'
            ])
        ]);
    }
    if (!($task['time_end'] > time())) {
        if (!\User::getAccount()->getInventory()->addItem([
            'item_id' => $recipe->item_id,
            'count' => $recipe->item_count
        ])) {
            \Flash::addMessageError('Не хватает место в инвентаре');
        } else {
            if (!$event_profession = User::getAccount()->getEvent()->findProfession($recipe->profession_id)) {
                $event_profession = User::getAccount()->getEvent()->addProfession($recipe->profession_id);
            }

            if($items = Event::doneCraftTask($recipe)) {
                User::getAccount()->getInventory()->addItem(...$items);

                foreach ($items AS $data) {
                    $item = Core::findItem($data['item_id']);
                    $table = new Ui\Table();
                    $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
                        'path' => '/images/items/' . $item->icon,
                        'count' => $recipe->item_count
                    ]));

                    $td = $table->addUiTd()->setStyle('width: 100%');
                    $td->addUiItem()->setItems([
                        ($recipe->item_count > 1 ? '[x' . $recipe->item_count . '] ' : null) .$item->title
                    ]);
                    $td->addUiItem()->setItems([
                        'Ивентовый предмет получено'
                    ]);
                    \Flash::addMessageSuccess($table);
                }
            }

            $event_profession->exp += Effect::findComponent('craft_exp')->getTotal($recipe->energy);

            $res = Core::getConnection()->prepare('SELECT percent FROM craft_experiences WHERE level = ? LIMIT 1');
            $res->execute([$event_profession->getExpProgress()->getLevel()]);

            if(!$data = $res->fetch()) {
                $data = [
                    'percent' => 0
                ];
            }

            $percent = $data['percent'];
            $exp = $recipe->energy * $percent / 100;

            User::getAccount()->exp += Effect::findComponent('exp')->getTotal($exp);
            User::getAccount()->craft_reputation += Effect::findComponent('craft_reputation')->getTotal($exp);

            $res = Core::getConnection()->prepare("DELETE FROM `craft_tasks`
            WHERE account_id = ? AND id = ? LIMIT 1");
            $res->execute([User::getAccount()->id, $task['id']]);

            $recipe_item = Core::findItem($recipe->item_id);
            $table = new Ui\Table();
            $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
                'path' => '/images/items/' . $recipe_item->icon,
                'count' => $recipe->item_count
            ]));

            $td = $table->addUiTd()->setStyle('width: 100%');
            $td->addUiItem()->setItems([
                ($recipe->item_count > 1 ? '[x' . $recipe->item_count . '] ' : null) .$recipe_item->title
            ]);
            $td->addUiItem()->setItems([
                'Предмет получено'
            ]);
            \Flash::addMessageSuccess($table);

            return new Response\Redirect([
                'url' => new Url('/account/craft', [
                    'from' => 'tasks'
                ])
            ]);
        }
    }

    return new Response\Redirect([
        'url' => new Url('/account/craft/task', [
            'id' => $task['id'],
        ])
    ]);
});

// Професия
$craft->addRoute('/profession', function () use ($page, $request) {
    if (!$profession = Core::findProfession(filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT))) {
        return new Response\Redirect([
            'url' => '/account/craft'
        ]);
    }
    if (!$event_profession = User::getAccount()->getEvent()->findProfession($profession->id)) {
        $event_profession = User::getAccount()->getEvent()->addProfession($profession->id);
    }

    $page->setTitle('Ремесло - ' . $profession->title);
    $page->addBreadcrumb()->setUrl('/account')->setItems([
        '<span class="icon white_arrow"></span><span class="text">Аккаунт</span>'
    ]);
    $page->addBreadcrumb()->setUrl('/account/craft')->setItems([
        '<span class="icon white_arrow"></span><span class="text">Ремесло</span>'
    ]);
    $page->addBreadcrumb()->setItems([
        '<span class="icon white_arrow"></span><span class="text">' . $profession->title . '</span>'
    ]);

    $page_content = $page->addUiContent();
    $listing = $page_content->addUiItem()->addUiListing();

    $listing_content = $listing->addUiContent();
    $table = $listing_content->addUiTable();
    $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
        'style' => 'width: 52px;',
        'path' => '/images/professions/' . $profession->icon,
    ]));

    $td = $table->addUiTd()->setStyle('width: 100%');
    $td->addUiItem()->setItems([
        '[' . $event_profession->getExpProgress()->getName() . '] ' .$profession->title
    ]);
    $td->addUiItem()->setItems([
        $event_profession->exp . ' / ' . $event_profession->getExpProgress()->getAllExp()
    ]);
    $td->addItem($event_profession->getExpProgress());

    // Листинг рецептов
    $listing = $page_content->addUiItem()->addUiListing();
    foreach ($profession->getRecipes() AS $recipe) {
        if (!$recipe_item = Core::findItem($recipe->item_id)) {
            continue;
        }
        $listing_content = $listing->addUiContent();
        $listing_content->setUrl(new Url('/account/craft/recipe', [
            'id' => $recipe->id,
            'profession' => $profession->id
        ]));
        $table = $listing_content->addUiTable();
        $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
            'style' => 'width: 40px;',
            'path' => '/images/items/' . $recipe_item->icon,
            'count' => $recipe->item_count
        ]));

        $td = $table->addUiTd();
        $td->setStyle('width: 100%');
        $td->addUiItem()->setItems([
            ($recipe->item_count > 1 ? '[x' . $recipe->item_count . '] ' : null) .$recipe_item->title
        ]);
        $td->addUiItem()->addItem(sprintf('<span>Время работы: %s</span>',
            when($recipe->life, true)
        ));
    }

    if (!$listing->getItems()) {
        $listing->addUiContent()->addUiItem()->addItem('Рецепты остусвует');
    }

    return $page;
});

// Рецепт
$recipe = $craft->addGroup('/recipe', function () use ($page, $request) {
    if (!$profession = Core::findProfession(filter_input(INPUT_GET, 'profession', FILTER_SANITIZE_NUMBER_INT))) {
        return new Response\Redirect([
            'url' => '/account/craft'
        ]);
    }
    if (!$event_profession = User::getAccount()->getEvent()->findProfession($profession->id)) {
        $event_profession = User::getAccount()->getEvent()->addProfession($profession->id);
    }
    if (!$recipe = $profession->findRecipe(filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT))) {
        return new Response\Redirect([
            'url' => new Url('/account/craft/profession', [
                'id' => $profession->id
            ])
        ]);
    }
    if (!$recipe_item = Core::findItem($recipe->item_id)) {
        return new Response\Redirect([
            'url' => new Url('/account/craft/profession', [
                'id' => $profession->id
            ])
        ]);
    }

    $page->setTitle($profession->title . ' - ' . $recipe_item->title);
    $page->addBreadcrumb()->setUrl('/account')->setItems([
        '<span class="icon white_arrow"></span><span class="text">Аккаунт</span>'
    ]);
    $page->addBreadcrumb()->setUrl('/account/craft')->setItems([
        '<span class="icon white_arrow"></span><span class="text">Ремесло</span>'
    ]);
    $page->addBreadcrumb()->setUrl(new Url('/account/craft/profession', [
        'id' => $profession->id
    ]))->setItems([
        '<span class="icon white_arrow"></span><span class="text">' . $profession->title . '</span>'
    ]);
    $page->addBreadcrumb()->setItems([
        '<span class="icon white_arrow"></span><span class="text">' . $recipe_item->title . '</span>'
    ]);

    // Основное страница контент
    $page_content = $page->addUiContent()->setItems([
        $ui_messages = new Ui()
    ]);
    $listing = $page_content->addUiItem()->addUiListing();

    $listing_content = $listing->addUiContent();
    $listing_content->addUiItem()->setItems([
        ($recipe->item_count > 1 ? '[x' . $recipe->item_count . '] ' : null) .$recipe_item->title
    ]);
    $table = $listing_content->addUiTable();
    $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
        'style' => 'width: 40px;',
        'path' => '/images/items/' . $recipe_item->icon,
        'count' => $recipe->item_count
    ]));

    $td = $table->addUiTd();
    $td->setStyle('width: 100%');

    if(User::getAccount()->energy < $recipe->energy) {
        $td->addUiItem()->setItems([
            '<b style="color: darkred">Очки работы: ' . $recipe->energy . '</b>'
        ]);
    } else {
        $td->addUiItem()->setItems([
            '<b>Очки работы: ' . $recipe->energy . '</b>'
        ]);
    }
    if($event_profession->exp < $recipe->exp) {
        $td->addUiItem()->setItems([
            '<b style="color: darkred">Ремесло: ' . $profession->title . ($recipe->exp ? ' ' . $recipe->exp : null) . '</b>'
        ]);
    } else {
        $td->addUiItem()->setItems([
            '<b>Ремесло: ' . $profession->title . ($recipe->exp ? ' ' . $recipe->exp : null) . '</b>'
        ]);
    }
    if ($recipe->life) {
        $listing_content = $listing->addUiContent();
        $listing_content->addUiItem()->addItem(sprintf('<span>Время работы: %s</span>',
            when($recipe->life, true)
        ));
    }

    if ($require_items = $recipe->getRequiredItems()) {
        $listing_content = $listing->addUiContent()->setItems([
            new Ui\Item([
                'items' => [
                    '<div><b>Материалы</b></div>'
                ]
            ])
        ]);

        foreach ($require_items AS $require_item) {
            $item = Core::findItem($require_item['item_id']);

            $table = $listing_content->addUiTable();
            $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
                'style' => 'width: 40px;',
                'path' => '/images/items/' . $item->icon,
                'count' => $require_item['count']
            ]));

            $res = Core::getConnection()->prepare('SELECT SUM(count) AS all_count 
            FROM inventory_items 
            WHERE item_id = ? AND account_id = ? LIMIT 1');
            $res->execute([$item->id, User::getAccount()->id]);

            if(!$data = $res->fetch()) {
                $data = [
                    'all_count' => 0
                ];
            }
            $all_count = $data['all_count'] ?? 0;
            $all_count = $all_count > 999 ? 999 : $all_count;
            $td = $table->addUiTd();
            $td->setStyle('width: 100%');

            if($all_count < $require_item['count']) {
                $td->addUiItem()->setItems([
                    $item->title . '<span class="title box red" style="float: right">' . $all_count . ' / ' . $require_item['count'] . '</span>'
                ]);
            } else {
                $td->addUiItem()->setItems([
                    $item->title . '<span class="title box green" style="float: right">' . $all_count . ' / ' . $require_item['count'] . '</span>'
                ]);
            }
        }
    }
    if (count(User::getAccount()->getCraft()->getTasks()) < User::getAccount()->slot_craft) {
        $page_content->addUiItem()->addItem(new Ui\Button([
            'url' => new Url('/account/craft/recipe/add', [
                'id' => $recipe->id,
                'profession' => $profession->id
            ]),
            'items' => [
                'Создать'
            ]
        ]));
    }
    foreach (\Flash::getMessages() AS $message) {
        $ui_messages->addItem(new Ui\Message([
            'type' => $message['type'],
            'items' => [
                new Ui\Item([
                    'items' => [
                        $message['text']
                    ]
                ])
            ]
        ]));
    }

    return $page;
});
$recipe->addRoute('/add', function () {
    if (!$profession = Core::findProfession(filter_input(INPUT_GET, 'profession', FILTER_SANITIZE_NUMBER_INT))) {
        return new Response\Redirect([
            'url' => '/account/craft'
        ]);
    }
    if (!$event_profession = User::getAccount()->getEvent()->findProfession($profession->id)) {
        $event_profession = User::getAccount()->getEvent()->addProfession($profession->id);
    }
    if (!$recipe = $profession->findRecipe(filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT))) {
        return new Response\Redirect([
            'url' => new Url('/account/craft/profession', [
                'id' => $profession->id
            ])
        ]);
    }
    if (!$recipe_item = Core::findItem($recipe->item_id)) {
        return new Response\Redirect([
            'url' => new Url('/account/craft/profession', [
                'id' => $profession->id
            ])
        ]);
    }

    if (count(User::getAccount()->getCraft()->getTasks()) < User::getAccount()->slot_craft) {
        if ($event_profession->exp < $recipe->exp) {
            Flash::addMessageError('Недостаточно мастерство');
        } else if (User::getAccount()->energy < $recipe->energy) {
            Flash::addMessageError('Недостаточно энергии');
        } else if (!\User::getAccount()->getInventory()->deleteItem(...$recipe->getRequiredItems())) {
            \Flash::addMessageError('Не хватает ресурсов');
        } else {
            $time_end = time() + $recipe->life;

            User::getAccount()->last_task_recipe = $recipe->id;
            User::getAccount()->energy -= $recipe->energy;

            $res = Core::getConnection()->prepare("INSERT INTO `craft_tasks` 
        (`account_id`, `recipe_id`, `time_end`) VALUES (?, ?, ?)");
            $res->execute([User::getAccount()->id, $recipe->id, $time_end]);
            \Flash::addMessageSuccess(new Ui\Item([
                'items' => [
                    sprintf('Задача "%s" успешно создан', $recipe_item->title)
                ]
            ]));

            return new Response\Redirect([
                'url' => new Url('/account/craft', [
                    'from' => 'tasks'
                ])
            ]);
        }
    }

    return new Response\Redirect([
        'url' => new Url('/account/craft/recipe', [
            'id' => $recipe->id,
            'profession' => $profession->id
        ])
    ]);
});