<?php
/**
 * @var \core\Module $this
 * @var \core\Router $router
 * @var \core\Request $request
 * @var \core\ui\Page $page
 * @var \core\router\Group $account
 */

use core\Module;
use core\Ui;
use core\Url;
use core\Response;

$achievements = $account->addGroup('/achievements', function () use ($page) {
    $page->setTitle('Достижения');
    $page->addBreadcrumb()->setUrl('/account')->setItems([
        '<span class="icon white_arrow"></span><span class="text">Аккаунт</span>'
    ]);
    $page->addBreadcrumb()->setItems([
        '<span class="icon white_arrow"></span><span class="text">Достижения</span>'
    ]);

    $page_content = $page->addUiContent()->setItems([
        $ui_messages = new Ui()
    ]);
    $listing = $page_content->addUiItem()->setItems([
        $tabs = new Ui\Table()
    ])->addUiListing();

    switch ($_GET['from'] ?? 'info') {
        case 'categories';
            $tabs->addUiTd()->setStyle('padding: 0 5px; width: 25%')->addUiTab()->setItems([
                new Ui\Content([
                    'url' => new Url(null, [
                        'from' => 'info'
                    ]),
                    'items' => [
                        new Ui\Item([
                            'items' => [
                                '<span class="title">Достижения</span>'
                            ]
                        ])
                    ]
                ])
            ]);
            $tabs->addUiTd()->setStyle('padding: 0 5px; width: 25%')->addUiTab()->setActive(true)->setItems([
                new Ui\Content([
                    'items' => [
                        new Ui\Item([
                            'items' => [
                                '<span class="title">Категории</span>'
                            ]
                        ])
                    ]
                ])
            ]);

            $listing_content = $listing->addUiContent();
            $listing_content->addUiItem()->addItem('Выбери категорию достижений, в которой желаешь добиться успеха, приложи все свое упорство и тебе не будет равных!');

            if ($achievements = Core::getAchievements()) {
                foreach ($achievements AS $category) {

                    $res = Core::getConnection()->prepare('SELECT COUNT(*) 
                    FROM achievement_steps 
                    WHERE achievement_category = ?');
                    $res->execute([$category->id]);
                    $max_count = $res->fetchColumn();

                    $res = Core::getConnection()->prepare('SELECT SUM(step) 
                    FROM event_achievements 
                    WHERE achievement_category = ? AND account_id = ?');
                    $res->execute([$category->id, User::getAccount()->id]);
                    $count = $res->fetchColumn();

                    $listing_content = $listing->addUiContent();
                    $listing_content->setUrl(new Url('/account/achievements/category', ['id' => $category->id]));
                    $table = $listing_content->addUiTable();
                    $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
                        'path' => '/images/achievements/' . $category->icon,
                    ]));

                    $td = $table->addUiTd()->setStyle('width: 100%');
                    $td->addUiItem()->setItems([
                        $category->title . ($max_count ? ' [' . ($count ?? 0) . ' из ' . $max_count . ']' : null)
                    ]);
                    $td->addUiItem()->setItems([
                        '<div class="time">' . $category->description . '</div>'
                    ]);
                }
            } else {
                $listing_content = $listing->addUiContent();
                $listing_content->addUiItem()->addItem('Достижение не найдено');
            }

            break;
        case 'info';
        default;
            $tabs->addUiTd()->setStyle('padding: 0 5px; width: 25%')->addUiTab()->setActive(true)->setItems([
                new Ui\Content([
                    'items' => [
                        new Ui\Item([
                            'items' => [
                                '<span class="title">Достижения</span>'
                            ]
                        ])
                    ]
                ])
            ]);
            $tabs->addUiTd()->setStyle('padding: 0 5px; width: 25%')->addUiTab()->setItems([
                new Ui\Content([
                    'url' => new Url(null, [
                        'from' => 'categories'
                    ]),
                    'items' => [
                        new Ui\Item([
                            'items' => [
                                '<span class="title">Категории</span>'
                            ]
                        ])
                    ]
                ])
            ]);

            $listing_content = $listing->addUiContent();
            $listing_content->addUiItem()->addItem('Странник или герой? Достиг ли ты славы в этом мире? Здесь ты сможешь понять, на что ты способен!');

            $res = Core::getConnection()->prepare("SELECT SUM(exp) AS all_exp
            FROM event_achievements 
            WHERE account_id = ?
            LIMIT 1");
            $res->execute([User::getAccount()->id]);
            $data = $res->fetch();

            $listing_content = $listing->addUiContent();
            $listing_content->addItem(new Ui\Table([
                'items' => [
                    new Ui\Td([
                        'items' => [
                            new Ui\Item([
                                'items' => [
                                    '<img class="icon box" src="/images/icons/16/medalred.png">'
                                ]
                            ])
                        ]
                    ]),
                    new Ui\Td([
                        'style' => 'width: 100%',
                        'items' => [
                            new Ui\Item([
                                'items' => [
                                    sprintf('<span>Очки достижении: %s</span>',
                                        $data['all_exp'])
                                ]
                            ])
                        ]
                    ])
                ]
            ]));

            $res = Core::getConnection()->prepare('SELECT COUNT(*) FROM achievement_steps');
            $res->execute();
            $max_count = $res->fetchColumn();

            $res = Core::getConnection()->prepare('SELECT SUM(step) 
                    FROM event_achievements 
                    WHERE account_id = ?');
            $res->execute([User::getAccount()->id]);
            $count = $res->fetchColumn();

            $listing_content->addItem(new Ui\Table([
                'items' => [
                    new Ui\Td([
                        'items' => [
                            new Ui\Item([
                                'items' => [
                                    '<img class="icon box" src="/images/icons/achievement.png">'
                                ]
                            ])
                        ]
                    ]),
                    new Ui\Td([
                        'style' => 'width: 100%',
                        'items' => [
                            new Ui\Item([
                                'items' => [
                                    sprintf('<span>Выполнено достижении: %s из %s</span>',
                                        $count, $max_count)
                                ]
                            ])
                        ]
                    ])
                ]
            ]));

            break;
    }

    return $page;
});
$achievements->addGroup('/category', function () use ($page) {
    if (!$category = Core::findAchievement(filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT))) {
        return new Response\Redirect([
            'url' => new Url('/account/achievements', [
                'from' => 'categories'
            ])
        ]);
    }

    $page->setTitle('Достижения');
    $page->addBreadcrumb()->setUrl('/account')->setItems([
        '<span class="icon white_arrow"></span><span class="text">Аккаунт</span>'
    ]);
    $page->addBreadcrumb()->setUrl(new Url('/account/achievements', [
        'from' => 'categories'
    ]))->setItems([
        '<span class="icon white_arrow"></span><span class="text">Достижения</span>'
    ]);
    $page->addBreadcrumb()->setItems([
        '<span class="icon white_arrow"></span><span class="text">' . $category->title . '</span>'
    ]);

    $page_content = $page->addUiContent();
    $listing = $page_content->addUiItem()->addUiListing();

    $listing_content = $listing->addUiContent();
    $table = $listing_content->addUiTable();
    $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
        'path' => '/images/achievements/' . $category->icon,
    ]));

    $td = $table->addUiTd()->setStyle('width: 100%');
    $td->addUiItem()->setItems([
        $category->title
    ]);
    $td->addUiItem()->setItems([
        '<div class="time">' . $category->description . '</div>'
    ]);

    if ($achievements = $category->getAchievements()) {
        foreach ($achievements AS $achievement) {
            if (!$event_achievement = User::getAccount()->getEvent()->findAchievement($achievement->id)) {
                $event_achievement = User::getAccount()->getEvent()->addAchievement($achievement->id, $category->id);
            }

            $res = Core::getConnection()->prepare('SELECT COUNT(*) 
                    FROM achievement_steps 
                    WHERE achievement_category = ? AND achievement_id = ?');
            $res->execute([$category->id, $achievement->id]);
            $max_count = $res->fetchColumn();

            $listing_content = $listing->addUiContent();
            $listing_content->setUrl(new Url('/account/achievement', [
                'id' => $achievement->id,
                'category' => $category->id
            ]));
            $table = $listing_content->addUiTable();
            $table->addUiTd()->addUiItem()->addItem('<img class="icon box" src="/images/icons/achievement.png">');

            $td = $table->addUiTd()->setStyle('width: 100%');
            $td->addUiItem()->setItems([
                $achievement->title . ($max_count ? ' [' . $event_achievement->step . ' из ' . $max_count . ']' : null)
            ]);
        }
    } else {
        $listing_content = $listing->addUiContent();
        $listing_content->addUiItem()->addItem('Достижение не найдено');
    }

    return $page;
});

$achievement = $account->addGroup('/achievement', function () use ($page) {
    if (!$category = Core::findAchievement(filter_input(INPUT_GET, 'category', FILTER_SANITIZE_NUMBER_INT))) {
        return new Response\Redirect([
            'url' => new Url('/account/achievements', [
                'from' => 'categories'
            ])
        ]);
    }
    if (!$achievement = $category->findAchievement(filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT))) {
        return new Response\Redirect([
            'url' => new Url('/account/achievements/category', [
                'id' => $category->id
            ])
        ]);
    }
    if (!$event_achievement = User::getAccount()->getEvent()->findAchievement($achievement->id)) {
        $event_achievement = User::getAccount()->getEvent()->addAchievement($achievement->id, $category->id);
    }

    $page->setTitle('Достижения - ' . $achievement->title);
    $page->addBreadcrumb()->setUrl('/account')->setItems([
        '<span class="icon white_arrow"></span><span class="text">Аккаунт</span>'
    ]);
    $page->addBreadcrumb()->setUrl(new Url('/account/achievements', [
        'from' => 'categories'
    ]))->setItems([
        '<span class="icon white_arrow"></span><span class="text">Достижения</span>'
    ]);
    $page->addBreadcrumb()->setUrl(new Url('/account/achievements/category', [
        'id' => $category->id
    ]))->setItems([
        '<span class="icon white_arrow"></span><span class="text">' . $category->title .'</span>'
    ]);
    $page->addBreadcrumb()->setItems([
        '<span class="icon white_arrow"></span><span class="text">' . $achievement->title . '</span>'
    ]);

    $page_content = $page->addUiContent();
    $listing = $page_content->addUiItem()->addUiListing();

    $listing_content = $listing->addUiContent();
    $table = $listing_content->addUiTable();
    $table->addUiTd()->addUiItem()->addItem(new Ui\Image([
        'path' => '/images/achievements/' . $category->icon,
    ]));

    $listing_content->addItem(new Ui\Table([
        'items' => [
            new Ui\Td([
                'items' => [
                    new Ui\Item([
                        'items' => [
                            '<img class="icon box" src="/images/icons/16/medalred.png">'
                        ]
                    ])
                ]
            ]),
            new Ui\Td([
                'style' => 'width: 100%',
                'items' => [
                    new Ui\Item([
                        'items' => [
                            sprintf('<span>Очки достижении: %s</span>',
                               $event_achievement->exp)
                        ]
                    ])
                ]
            ])
        ]
    ]));
    $listing_content->addItem(new Ui\Table([
        'items' => [
            new Ui\Td([
                'items' => [
                    new Ui\Item([
                        'items' => [
                            '<img class="icon box" src="/images/icons/achievement.png">'
                        ]
                    ])
                ]
            ]),
            new Ui\Td([
                'style' => 'width: 100%',
                'items' => [
                    new Ui\Item([
                        'items' => [
                            sprintf('<span>Прогресс: %s из %s</span>',
                                $event_achievement->step, count($achievement->getSteps()))
                        ]
                    ])
                ]
            ])
        ]
    ]));

    $td = $table->addUiTd()->setStyle('width: 100%');
    $td->addUiItem()->setItems([
        $achievement->title
    ]);

    $listing = $page_content->addUiItem()->addUiListing();
    $listing->addUiContent()->addUiItem()->setItems([
        '<strong class="title">Титулы</strong>'
    ]);
    foreach ($achievement->getSteps() AS $step => $data) {
        $listing_content = $listing->addUiContent();
        $table = $listing_content->addUiTable();

        if($event_achievement->step > $step) {
            $table->addUiTd()->addUiItem()->addItem('<img class="icon box" src="/images/icons/tick.png">');
            $table->addUiTd()->setStyle('width: 100%')->addUiItem()->setItems([
                '<strong>' . $data['title'] . '</strong>'
            ]);
            $listing_content->addUiItem()->addItem($data['description_completed']);
        } else {
            $table->addUiTd()->addUiItem()->addItem('<img class="icon box" src="/images/icons/question_silver.png">');
            $table->addUiTd()->setStyle('width: 100%')->addUiItem()->setItems([
                '<strong>' . $data['title'] . '</strong>'
            ]);
            $listing_content->addUiItem()->addItem($data['description']);
        }
    }

    return $page;
});