<?php
/**
 * @var \core\Module $this
 * @var \core\Router $router
 * @var \core\Request $request
 * @var \core\ui\Page $page
 */

use core\Ui;
use core\Url;
use data\Account;

$page->addMenu('foot_menu', [
    'url' => '/rating',
    'title' => 'Рейтинг'
]);
$rating = $router->addGroup('/rating', function () use ($page, $request) {

    $page->setTitle('Рейтинг');
    $page->setItems([
        $content = new Ui\Content([
            'items' => [
                $ui = new Ui()
            ]
        ])
    ]);
    $ui->addItem(new Ui\Item([
        'items' => [
            $item = new Ui([
                'items' => [
                    $tabs = new Ui(),
                    new Ui\Listing([
                        'items' => [
                            $listing = new Ui()
                        ]
                    ])
                ]
            ])
        ]
    ]));
    $page->addBreadcrumb([
        'items' => [
            '<span class="icon white_arrow"></span><span class="text">Рейтинг</span>'
        ]
    ]);

    switch ($_GET['from'] ?? 'level') {
        case 'craft';
            $tabs->addItem(new Ui\Table([
                'items' => [
                    $table = new Ui([
                        'items' => [
                            new Ui\Td([
                                'style' => 'padding: 0 5px; width: 25%',
                                'items' => [
                                    new Ui\Tab([
                                        'items' => [
                                            new Ui\Content([
                                                'url' => new Url(null, [
                                                    'from' => 'level'
                                                ]),
                                                'items' => [
                                                    new Ui\Item([
                                                        'items' => [
                                                            '<span class="title">Уровень</span>'
                                                        ]
                                                    ])
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ]),
                            new Ui\Td([
                                'style' => 'padding: 0 5px; width: 25%',
                                'items' => [
                                    new Ui\Tab([
                                        'items' => [
                                            new Ui\Content([
                                                'url' => new Url(null, [
                                                    'from' => 'achievement'
                                                ]),
                                                'items' => [
                                                    new Ui\Item([
                                                        'items' => [
                                                            '<span class="title">Достижения</span>'
                                                        ]
                                                    ])
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ]),
                            new Ui\Td([
                                'style' => 'padding: 0 5px; width: 25%',
                                'items' => [
                                    new Ui\Tab([
                                        'active' => true,
                                        'items' => [
                                            new Ui\Content([
                                                'items' => [
                                                    new Ui\Item([
                                                        'items' => [
                                                            '<span class="title">Ремесло</span>'
                                                        ]
                                                    ])
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ])
                ]
            ]));

            $res = Core::getConnection()->query("SELECT account_id , SUM(exp) AS all_exp
            FROM event_professions 
            GROUP BY account_id 
            ORDER BY all_exp DESC 
            LIMIT 10");

            if ($professions = $res->fetchAll()) {
                /**
                 * @var $account Account
                 */
                foreach ($professions AS $data) {
                    $account = Core::findAccount($data['account_id']);
                    $content = $listing->addUiContent();
                    $content->addUiItem()->addItem('<b>' . $account->login . '</b>');
                    $content->addUiItem()->addItem(sprintf('<img src="/images/icons/10/exp.png"> <span>Мастерство ремесло: %s</span>',
                        $data['all_exp']));
                }
            } else {
                $listing->addUiContent()->addUiItem()->addItem('Нет игроков');
            }

            break;
        case 'achievement';
            $tabs->addItem(new Ui\Table([
                'items' => [
                    $table = new Ui([
                        'items' => [
                            new Ui\Td([
                                'style' => 'padding: 0 5px; width: 25%',
                                'items' => [
                                    new Ui\Tab([
                                        'items' => [
                                            new Ui\Content([
                                                'url' => new Url(null, [
                                                    'from' => 'level'
                                                ]),
                                                'items' => [
                                                    new Ui\Item([
                                                        'items' => [
                                                            '<span class="title">Уровень</span>'
                                                        ]
                                                    ])
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ]),
                            new Ui\Td([
                                'style' => 'padding: 0 5px; width: 25%',
                                'items' => [
                                    new Ui\Tab([
                                        'active' => true,
                                        'items' => [
                                            new Ui\Content([
                                                'items' => [
                                                    new Ui\Item([
                                                        'items' => [
                                                            '<span class="title">Достижения</span>'
                                                        ]
                                                    ])
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ]),
                            new Ui\Td([
                                'style' => 'padding: 0 5px; width: 25%',
                                'items' => [
                                    new Ui\Tab([
                                        'items' => [
                                            new Ui\Content([
                                                'url' => new Url(null, [
                                                    'from' => 'craft'
                                                ]),
                                                'items' => [
                                                    new Ui\Item([
                                                        'items' => [
                                                            '<span class="title">Ремесло</span>'
                                                        ]
                                                    ])
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ])
                ]
            ]));

            $res = Core::getConnection()->query("SELECT account_id , SUM(exp) AS all_exp
            FROM event_achievements 
            GROUP BY account_id 
            ORDER BY all_exp DESC 
            LIMIT 10");

            if ($achievements = $res->fetchAll()) {
                /**
                 * @var $account Account
                 */
                foreach ($achievements AS $data) {
                    $account = Core::findAccount($data['account_id']);
                    $content = $listing->addUiContent();
                    $content->addUiItem()->addItem('<b>' . $account->login . '</b>');
                    $content->addUiItem()->addItem(sprintf('<img src="/images/icons/10/exp.png"> <span>Очки достижении: %s</span>',
                        $data['all_exp']));
                }
            } else {
                $listing->addUiContent()->addUiItem()->addItem('Нет игроков');
            }

            break;
        case 'level';
        default;
            $tabs->addItem(new Ui\Table([
                'items' => [
                    $table = new Ui([
                        'items' => [
                            new Ui\Td([
                                'style' => 'padding: 0 5px; width: 25%',
                                'items' => [
                                    new Ui\Tab([
                                        'active' => true,
                                        'items' => [
                                            new Ui\Content([
                                                'items' => [
                                                    new Ui\Item([
                                                        'items' => [
                                                            '<span class="title">Уровень</span>'
                                                        ]
                                                    ])
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ]),
                            new Ui\Td([
                                'style' => 'padding: 0 5px; width: 25%',
                                'items' => [
                                    new Ui\Tab([
                                        'items' => [
                                            new Ui\Content([
                                                'url' => new Url(null, [
                                                    'from' => 'achievement'
                                                ]),
                                                'items' => [
                                                    new Ui\Item([
                                                        'items' => [
                                                            '<span class="title">Достижения</span>'
                                                        ]
                                                    ])
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ]),
                            new Ui\Td([
                                'style' => 'padding: 0 5px; width: 25%',
                                'items' => [
                                    new Ui\Tab([
                                        'items' => [
                                            new Ui\Content([
                                                'url' => new Url(null, [
                                                    'from' => 'craft'
                                                ]),
                                                'items' => [
                                                    new Ui\Item([
                                                        'items' => [
                                                            '<span class="title">Ремесло</span>'
                                                        ]
                                                    ])
                                                ]
                                            ])
                                        ]
                                    ])
                                ]
                            ])
                        ]
                    ])
                ]
            ]));

            $res = Core::getConnection()->query("SELECT * FROM accounts ORDER BY exp DESC LIMIT 10");
            if ($accounts = $res->fetchAll(\PDO::FETCH_CLASS, Account::class)) {
                /**
                 * @var $account Account
                 */
                foreach ($accounts AS $account) {
                    $content = $listing->addUiContent();
                    $content->addUiItem()->addItem('<b>' . $account->login . '</b>');
                    $content->addUiItem()->addItem(sprintf('<img src="/images/icons/10/level.png"> <span>Уровень: %s</span>',
                        $account->getExpProgress()->getLevel()));
                    $content->addUiItem()->addItem(sprintf('<img src="/images/icons/10/exp.png"> <span>Опыт: %s</span>',
                        $account->getExpProgress()->getExp()));
                }
            } else {
                $listing->addUiContent()->addUiItem()->addItem('Нет игроков');
            }
            break;
    }
    return $page;
});