<?php
/**
 * @var \core\Module $this
 * @var \core\Router $router
 * @var \core\Request $request
 * @var \core\ui\Page $page
 */

use core\Ui;
use core\Url;
use data\Account;

$page->addMenu('foot_menu', [
    'url' => '/chat',
    'title' => 'Чат'
]);
$rating = $router->addGroup('/chat', function () use ($page, $request) {
    $page->setTitle('Чат');
    $page->setItems([
        $content = new Ui\Content([
            'items' => [
                $ui = new Ui()
            ]
        ])
    ]);
    $ui->addItem(new Ui\Item([
        'items' => [
            $item = new Ui([
                'items' => [
                    $tabs = new Ui(),
                    new Ui\Listing([
                        'items' => [
                            $listing = new Ui()
                        ]
                    ])
                ]
            ])
        ]
    ]));
    $page->addBreadcrumb([
        'items' => [
            '<span class="icon white_arrow"></span><span class="text">Чат</span>'
        ]
    ]);




    return $page;
});