<?php

use data\Account;

abstract class User
{
    protected static $account;

    /**
     * @return Account
     */
    public static function getAccount() {
        if (!self::$account) {
            self::$account = Core::findAccount(self::getAuthID());
        }
        return self::$account;
    }

    /**
     * @param $login
     * @param $password
     * @return bool
     */
    public static function authAccount($login, $password) {
        $res = Core::getConnection()->prepare("SELECT * FROM accounts WHERE login = ? LIMIT 1");
        $res->execute([$login]);

        if(!$data = $res->fetch()) {
            Flash::addMessageError('Аккаунт не найдено');
            return false;
        } else if (md5($password . $data['salt']) !== $data['password']) {
            Flash::addMessageError('Пароль не верный');
            return false;
        }

        $_SESSION['auth_token'] = self::generateAuthToken($data['id']);
        return true;
    }

    /**
     * @param $login
     * @param $password
     * @return bool
     */
    public static function newAccount($login, $password) {
        $find = Core::getConnection()->prepare("SELECT * FROM accounts WHERE login = ? LIMIT 1");
        $find->execute([$login]);

        if($data = $find->fetch()) {
            Flash::addMessageError(sprintf('Аккаунт под логином "%s" занят', $login));
            return false;
        }

        $salt = generator();
        $password = md5($password . $salt);

        $res = Core::getConnection()->prepare("INSERT INTO accounts 
        (login, password, salt, data_register) VALUES (?, ?, ?, ?)");
        $res->execute([$login, $password, $salt, time()]);

        $_SESSION['auth_token'] = self::generateAuthToken(Core::getConnection()->lastInsertId());
        return true;
    }

    /**
     * @return bool
     */
    public static function exitAccount() {
        if(isset($_SESSION['auth_token'])) {
            unset($_SESSION['auth_token']);
            return true;
        }
        return false;
    }

    /**
     * @return bool
     */
    public static function isAuth() {
        if(!$account = self::getAccount()) {
            return false;
        }

        return true;
    }

    /**
     * @return bool|int
     */
    protected static function getAuthID() {
        if(isset($_SESSION['auth_token'])) {
            $res = Core::getConnection()->prepare("SELECT * FROM auth_accounts WHERE token = ? LIMIT 1");
            $res->execute([$_SESSION['auth_token']]);

            if(!$data = $res->fetch()) {
                unset($_SESSION['auth_token']);
                return false;
            }

            $token = md5(generator());
            $_SESSION['auth_token'] = $token;

            $res = Core::getConnection()->prepare("UPDATE auth_accounts SET token = ?, time = ? WHERE account_id = ?");
            $res->execute([$token, time(), $data['account_id']]);

            return $data['account_id'];
        }

        return false;
    }

    /**
     * @param $account_id
     * @return string
     */
    protected static function generateAuthToken($account_id) {
        $res = Core::getConnection()->prepare("SELECT * FROM auth_accounts WHERE account_id = ? LIMIT 1");
        $res->execute([$account_id]);

        if (!$data = $res->fetch()) {
            $token = md5($account_id . generator());
            $res = Core::getConnection()->prepare("INSERT INTO auth_accounts 
            (account_id, token, time) VALUES (?, ?, ?)");
            $res->execute([$account_id, $token, time()]);
            return $token;
        }

        $token = md5($account_id . generator());

        $res = Core::getConnection()->prepare("UPDATE auth_accounts SET token = ?, time = ? WHERE account_id = ?");
        $res->execute([$token, time(), $account_id]);

        return $token;
    }
}