<?php

abstract class Theme
{
    protected static $components = [];

    public static function getComponents()
    {
        if (!self::$components) {
            $theme_files = (array)glob(DIR_ENGINE . '/themes/*', GLOB_ONLYDIR);

            foreach ($theme_files AS $theme_file) {
                if (!file_exists($theme_file . '/config.json')) {
                    continue;
                }

                $json = file_get_contents($theme_file . '/config.json');
                self::$components[] = \Json::parse($json);
            }
        }

        return self::$components;
    }

    /**
     * Возвращает текущую тему оформления
     * @return string
     * @throws \Exception
     */
    public static function getCurrentTheme()
    {
        $current_theme = 'mobile';

        if (!$current_theme) {
            throw new \Exception(sprintf("Не найдено ни одной активной темы оформления"));
        }

        return $current_theme;
    }

    public static function findView($name, $class_name)
    {
        $config = self::findConfig($name);
        $path_theme = DIR_ENGINE . '/themes/' . $name;
        $path_views = $config['path'];
        return realpath($path_theme . '/' . $path_views . '/' . $class_name . '.php');
    }

    public static function findResource($name, $type)
    {
        $config = self::findConfig($name);
        $path_theme = DIR_ENGINE . '/themes/' . $name;

        if (!array_key_exists('resources', $config) || !array_key_exists($type, $config['resources'])) {
            return [];
        }

        $all_files_rel_path = [];
        $patterns = (array)$config['resources'][$type];
        foreach ($patterns AS $pattern) {
            $files_abs_path = (array)glob($path_theme . '/' . $pattern, GLOB_NOSORT);
            foreach ($files_abs_path AS $file_abs_path) {
                $all_files_rel_path[] = \FileSystem::getRelPath($file_abs_path);
            }
        }

        return array_unique($all_files_rel_path);
    }

    public static function findConfig($name)
    {
        foreach (self::getComponents() AS $component) {
            if ($component['name'] != $name) {
                continue;
            }

            return $component;
        }

        return [];
    }
}