<?php

abstract class Package
{
    protected static $config_components = [];
    protected static $components = [];

    /**
     * @return array
     */
    public static function getComponents()
    {
        if (!self::$config_components[self::getType()]) {
            $config_paths = (array) glob(DIR_ENGINE  . '/packages/' . self::getType() . '/components/*', GLOB_ONLYDIR);
            foreach ($config_paths AS $config_path) {
                if (!file_exists($config_path . '/config.json')) {
                    continue;
                }

                $config_json = file_get_contents($config_path . '/config.json');
                $config = \Json::parse($config_json);
                self::$config_components[self::getType()][] = $config;
            }
        }
        return self::$config_components[self::getType()];
    }

    /**
     * @return array
     */
    public static function getList()
    {
        $list = [];
        foreach (self::getComponents() AS $component) {
            if ($component['type'] != self::getType()) {
                continue;
            }
            $list[] = $component['name'];
        }
        return $list;
    }

    /**
     * @param $name
     * @return bool
     */
    public static function isComponent($name)
    {
        return in_array($name, self::getList());
    }

    /**
     * @param $name
     * @return bool|Component
     * @throws Exception
     */
    public static function findComponent($name)
    {
        if (!self::isComponent($name)) {
            return false;
        }

        $type = self::getType();
        $key = $type . '|' . $name;
        if (!array_key_exists($key, self::$components)) {
            $class_name = '\\' . $type . '\\components\\' . $name . '\\component';
            $instance = new $class_name(self::findConfig($name));
            self::$components[$key] = $instance;
        }
        return self::$components[$key];
    }

    /**
     * @param $name
     * @return array
     * @throws Exception
     */
    public static function findConfig($name)
    {
        if (!self::isComponent($name)) {
            throw new \Exception(sprintf("Пакет %s не найден", $name));
        }

        foreach (self::getComponents() AS $component) {
            if ($component['name'] != $name OR $component['type'] != self::getType()) {
                continue;
            }

            return $component;
        }

        return [];
    }

    /**
     * @return string
     */
    public static function getType() {
        return strtolower((new \ReflectionClass(static::class))->getShortName());
    }
}