<?php

abstract class Json
{
    public static function parse($string)
    {
        $model = json_decode($string, true);
        $err = json_last_error();
        switch ($err) {
            case JSON_ERROR_DEPTH:
                throw new \Exception('Maximum stack depth exceeded');
            case JSON_ERROR_CTRL_CHAR:
                throw new \Exception('Unexpected control character found');
            case JSON_ERROR_SYNTAX:
                throw new \Exception('Syntax error, malformed JSON');
            case JSON_ERROR_NONE:
            default:
                return $model;
        }
    }

    public static function stringify($model, $format = true)
    {
        $flags = JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES;
        if ($format) {
            $flags = $flags | JSON_PRETTY_PRINT;
        }

        return json_encode($model, $flags);
    }
}