<?php

abstract class Flash
{
    public static function getMessages($remove = true)
    {
        if (!isset($_SESSION['_flashMessages'])) {
            return [];
        }

        $messages = $_SESSION['_flashMessages'];
        if ($remove === true) {
            unset($_SESSION['_flashMessages']);
        }
        return $messages;
    }

    public static function getSystemMessages($remove = true)
    {
        if (!isset($_SESSION['_flashSystemsMessages'])) {
            return [];
        }

        $messages = $_SESSION['_flashSystemsMessages'];
        if ($remove === true) {
            unset($_SESSION['_flashSystemsMessages']);
        }
        return $messages;
    }

    public static function addMessageError($string)
    {
        $_SESSION['_flashMessages'][] = [
            'text' => $string,
            'type' => 'error'
        ];
    }

    public static function addMessageSuccess($string)
    {
        $_SESSION['_flashMessages'][] = [
            'text' => $string,
            'type' => 'success'
        ];
    }

    public static function addSystemMessage($string)
    {
        $_SESSION['_flashSystemsMessages'][] = [
            'text' => $string,
            'type' => 'info'
        ];
    }

    public static function getInput($name, $remove = true)
    {
        if (!isset($_SESSION['_flashInputs'][$name])) {
            return false;
        }

        $value = $_SESSION['_flashInputs'][$name];
        if ($remove === true) {
            unset($_SESSION['_flashInputs'][$name]);
        }

        return $value;
    }

    public static function addInput($name, $value)
    {
        $_SESSION['_flashInputs'][$name] = $value;
    }

    public function __destruct()
    {
        unset($_SESSION['_flashSystemsMessages']);
        unset($_SESSION['_flashMessages']);
        unset($_SESSION['_flashInputs']);
    }
}