<?php

namespace data\profession;

/**
 * Профессия [profession]
 * @property int profession_id
 * @property int item_id
 * @property int item_count
 *
 * @property int exp
 * @property int life
 * @property int level
 * @property int energy
 * @property int money
 */
class Recipe extends \Data
{
    protected $profession_id = 0;
    protected $item_id = 0;
    protected $item_count = 1;
    protected $money = 0;
    protected $exp = 0;
    protected $life = 0;
    protected $level = 1;
    protected $energy = 0;

    protected $required_items = [];

    /**
     * @return array
     */
    public function getRequiredItems()
    {
        if (!$this->required_items) {
            $res = \Core::getConnection()->prepare('SELECT * FROM `recipe_required_items` WHERE `recipe_id` = ?');
            $res->execute([$this->id]);

            $this->required_items = $res->fetchAll();
        }

        return $this->required_items;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'profession_recipes';
    }
}