<?php

namespace data;

use data\profession\Recipe;

/**
 * Профессия [profession]
 * @property string title
 * @property string icon
 */
class Profession extends \Data
{
    protected $title;
    protected $icon;

    protected $recipes = [];

    /**
     * @return Recipe[]
     */
    public function getRecipes()
    {
        if (!$this->recipes) {
            $res = \Core::getConnection()->prepare("SELECT id, id, life, energy, exp, item_id, item_count
            FROM `profession_recipes` 
            WHERE `profession_id` = ?");
            $res->execute([$this->id]);
            $this->recipes = $res->fetchAll(\PDO::FETCH_UNIQUE|\PDO::FETCH_CLASS, Recipe::class);
        }
        return $this->recipes;
    }

    /**
     * @param int $id
     * @return Recipe
     */
    public function findRecipe(int $id = 0) {
        if(!isset($this->recipes[$id])) {
            $res = \Core::getConnection()->prepare("SELECT * FROM `profession_recipes` 
            WHERE `id` = ? AND `profession_id` = ? LIMIT 1");
            $res->execute([$id, $this->id]);
            $this->recipes[$id] = $res->fetchObject(Recipe::class);
        }
        return $this->recipes[$id];
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'professions';
    }
}