<?php

namespace data;

/**
 * Class Building
 * @package data
 *
 * @property int parent_id
 * @property string name
 */
class Building extends \Data
{
    protected $parent_id;
    protected $name;

    protected $npcs = [];

    /**
     * @return Npc[]
     */
    public function getNpcs()
    {
        if (!$this->npcs) {
            $res = \Core::getConnection()->prepare("SELECT id, id, name
            FROM `location_npcs`
            WHERE building_id = ?");
            $res->execute([$this->id]);
            $this->npcs = $res->fetchAll(\PDO::FETCH_UNIQUE|\PDO::FETCH_CLASS, Npc::class);
        }
        return $this->npcs;
    }

    /**
     * @param int $id
     * @return Npc
     */
    public function findNpc($id) {
        if(!isset($this->npcs[$id])) {
            $res = \Core::getConnection()->prepare("SELECT * FROM `location_npcs` 
            WHERE `id` = ? AND building_id = ? LIMIT 1");
            $res->execute([$id, $this->id]);
            $this->npcs[$id] = $res->fetchObject(Npc::class);
        }
        return $this->npcs[$id];
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'location_buildings';
    }
}