<?php

namespace data\account\event;
use core\ui\Progress;

/**
 * Class Profession
 * @package data\account\event
 * @property int exp
 */
class Profession extends \Data
{
    /**
     * Profession constructor.
     * @param int $profession_id
     * @param int $account_id
     */
    public function __construct($profession_id = 0, $account_id = 0)
    {
        $this->profession_id = $profession_id;
        $this->account_id = $account_id;
    }

    protected $account_id = 0;
    protected $profession_id = 0;
    protected $exp = 0;
    protected $config = '{}';

    protected $exp_progress;

    /**
     * @return Progress
     */
    public function getExpProgress()
    {
        if (!$this->exp_progress) {
            $this->exp_progress = new Progress($this->exp, [
                0 => 1000,
                1 => 10000,
                2 => 10000,
                3 => 10000,
                4 => 10000
            ]);
        }
        return $this->exp_progress;
    }

    public function __destruct()
    {
        parent::__destruct();
        if(!$this->id AND $this->profession_id AND $this->account_id) {
            $res = \Core::getConnection()->prepare("INSERT INTO event_professions 
            (profession_id, account_id, config) VALUES (?, ?, ?)");
            $res->execute([$this->profession_id , $this->account_id, $this->config]);
            $this->id = \Core::getConnection()->lastInsertId();
        }
    }

    /**
     * @return string
     */
    public function getName()
    {
       return 'event_professions';
    }
}