<?php

namespace data\account;

class Craft
{
    protected $id = 0;
    protected $tasks = [];

    /**
     * Craft constructor.
     * @param int $id
     */
    public function __construct($id = 0)
    {
        $this->id = $id;
    }

    /**
     * @return array[]
     */
    public function getTasks()
    {
        if (!$this->tasks) {
            $res = \Core::getConnection()->prepare("SELECT id, id, recipe_id, time_end FROM `craft_tasks` WHERE `account_id` = ?");
            $res->execute([$this->id]);
            $this->tasks = $res->fetchAll(\PDO::FETCH_UNIQUE|\PDO::FETCH_ASSOC);
        }
        return $this->tasks;
    }

    /**
     * @param int $id
     * @return array
     */
    public function findTask(int $id = 0) {
        if(!isset($this->tasks[$id])) {
            $res = \Core::getConnection()->prepare("SELECT * FROM `craft_tasks` 
            WHERE `id` = ? AND `account_id` = ? LIMIT 1");
            $res->execute([$id, $this->id]);
            $this->tasks[$id] = $res->fetch(\PDO::FETCH_ASSOC);
        }
        return $this->tasks[$id];
    }
}