<?php

namespace data;

use core\ui\Progress;
use core\ui\progress\Energy;
use data\account\Craft;
use data\account\Event;
use data\account\Inventory;
use data\account\Mail;

/**
 * Аккаунт [auth]
 * @property string login
 * @property string password
 * @property string salt
 *
 * @property int data_register
 *
 * @property int exp
 * @property int energy
 * @property int money
 * @property int slot_craft
 * @property int slot_inventory
 * @property int last_task_recipe
 * @property int craft_reputation
 */
class Account extends \Data
{
    protected $login;
    protected $password;
    protected $salt;
    protected $exp = 0;
    protected $energy = 0;
    protected $money = 0;
    protected $data_register = 0;
    protected $craft_reputation = 0;
    protected $slot_craft = 3;
    protected $slot_inventory = 5;
    protected $last_task_recipe = 0;

    protected $craft;
    protected $inventory;
    protected $mail;
    protected $finance;
    protected $event;
    protected $exp_progress;
    protected $energy_progress;

    /**
     * @return Craft
     */
    public function getCraft() {
        if(!$this->craft) {
            $this->craft = new Craft($this->id);
        }

        return $this->craft;
    }

    /**
     * @return Inventory
     */
    public function getInventory() {
        if(!$this->inventory) {
            $this->inventory = new Inventory($this->id, $this->slot_inventory);
        }

        return $this->inventory;
    }

    /**
     * @return Mail
     */
    public function getMail() {
        if(!$this->mail) {
            $this->mail = new Mail($this->id);
        }

        return $this->mail;
    }

    /**
     * @return Event
     */
    public function getEvent() {
        if(!$this->event) {
            $this->event = new Event($this->id);
        }

        return $this->event;
    }

    /**
     * @return Progress
     */
    public function getExpProgress()
    {
        if (!$this->exp_progress) {
            $this->exp_progress = new Progress($this->exp, [
                1 => 10,
                2 => 50,
                3 => 100,
                4 => 200,
                5 => 400,
                6 => 800,
                7 => 1600,
                8 => 3200,
                9 => 6400,
                10 => 12800
            ]);
        }
        return $this->exp_progress;
    }

    /**
     * @return Energy
     */
    public function getEnergyProgress()
    {
        if (!$this->energy_progress) {
            $this->energy_progress = new Energy($this, [
                1 => 100,
                2 => 200,
                3 => 300,
                4 => 400,
                5 => 500,
                6 => 600
            ]);
        }
        return $this->energy_progress;
    }

    public function isAccess($group)
    {
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'accounts';
    }
}