<?php

namespace core\ui\progress;

use core\Ui;
use data\Account;

class Energy extends Ui
{
    protected $current_energy = 0;
    protected $max_energy = 0;
    protected $percent_energy = 0;

    /**
     * Progress constructor.
     * @param Account $account
     * @param array $levels
     * @param array $config
     */
    function __construct(Account $account, array $levels, array $config = [])
    {
        parent::__construct($config);

        // Энергия
        $current_energy = $account->energy;
        $max_energy = 0;

        // Процент энергия
        $percent_energy = 0;

        foreach ($levels AS $level => $add_energy) {
            if ($account->getExpProgress()->getLevel() < $level) {
                break;
            }

            $max_energy = $add_energy;
            $percent_energy = $current_energy * 100 / $max_energy;
        }

        // Сохранить энергии
        $this->current_energy = $current_energy;
        $this->max_energy = $max_energy;

        // Сохранить процент энергии
        $this->percent_energy = min(max(0, $percent_energy), 100);
    }

    public function getEnergy()
    {
        return (int)$this->current_energy;
    }

    public function getMaxEnergy()
    {
        return (int)$this->max_energy;
    }

    public function getPercentEnergy()
    {
        return (int)$this->percent_energy;
    }
}