<?php

namespace core\ui;

use core\Ui;

class Page extends Ui
{
    protected $title = '[Пустой заголовок]';
    protected $stylesheets = [];
    protected $scripts = [];
    protected $breadcrumbs = [];
    protected $list_menu = [];

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @param string $title
     */
    public function setTitle(string $title)
    {
        $this->title = $title;
    }

    /**
     * @return array
     */
    public function getStylesheets(): array
    {
        return $this->stylesheets;
    }

    /**
     * @param array $stylesheets
     */
    public function setStylesheets(array $stylesheets)
    {
        $this->stylesheets = $stylesheets;
    }

    /**
     * @return array
     */
    public function getScripts(): array
    {
        return $this->scripts;
    }

    /**
     * @param array $scripts
     */
    public function setScripts(array $scripts)
    {
        $this->scripts = $scripts;
    }

    /**
     * @return array
     */
    public function getBreadcrumbs(): array
    {
        return $this->breadcrumbs;
    }

    /**
     * @param array $breadcrumbs
     */
    public function setBreadcrumbs(array $breadcrumbs)
    {
        $this->breadcrumbs = $breadcrumbs;
    }

    /**
     * @param $breadcrumb
     * @return Breadcrumb
     */
    public function addBreadcrumb($breadcrumb = []): Breadcrumb
    {
        if (!$breadcrumb instanceof Breadcrumb) {
            $breadcrumb = new Breadcrumb([
                'url' => $breadcrumb['url'] ?? null,
                'items' => $breadcrumb['items'] ?? []
            ]);
        }

        return $this->breadcrumbs[] = $breadcrumb;
    }

    /**
     * @param $name
     * @return array|mixed
     */
    public function findListMenu($name)
    {
        if (!isset($this->list_menu[$name])) {
            return [];
        }

        return $this->list_menu[$name];
    }

    /**
     * @param $name
     * @param $data
     * @param bool $order
     */
    public function addMenu($name, $data, $order = false)
    {
        if ($order) {
            $this->list_menu[$name][$order] = $data;
        } else {
            $this->list_menu[$name][] = $data;
        }

        ksort($this->list_menu[$name], SORT_NUMERIC);
    }
}