<?php

namespace core\ui;

use core\Ui;

class Money extends Ui
{
    protected $gold = 0;
    protected $silver = 0;
    protected $bronze = 0;

    /**
     * Money constructor.
     * @param int $money
     * @param array $config
     */
    function __construct($money, array $config = [])
    {
        parent::__construct($config);

        $this->gold = (int)($money / 10000);
        $this->silver = (int)(($money - $this->gold * 10000) / 100);
        $this->bronze = (int)($money - $this->gold * 10000) - ($this->silver * 100);
    }

    public function getGold()
    {
        return (int)$this->gold;
    }

    public function getSilver()
    {
        return (int)$this->silver;
    }

    public function getBronze()
    {
        return (int)$this->bronze;
    }
}