<?php

namespace core;

class Ui extends \Configurator
{
    protected $items = [];

    /**
     * @param ui[]|array[] $items []
     */
    public function setItems($items)
    {
        $this->items = [];
        foreach ($items AS $item) {
            $this->addItem($item);
        }
        return $this;
    }

    /**
     * @return ui[]
     */
    public function getItems()
    {
        return $this->items;
    }

    /**
     * @param ui|array $ui
     * @throws \Exception
     */
    public function addItem($ui)
    {
        $this->items[] = $ui;
    }

    /**
     * @return Ui\Content
     */
    public function addUiContent()
    {
        return $this->items[] = new Ui\Content();
    }

    /**
     * @return Ui\Item
     */
    public function addUiItem()
    {
        return $this->items[] = new Ui\Item();
    }

    /**
     * @return Ui\Listing
     */
    public function addUiListing()
    {
        return $this->items[] = new Ui\Listing();
    }


    /**
     * @return Ui\Table
     */
    public function addUiTable()
    {
        return $this->items[] = new Ui\Table();
    }

    /**
     * @return Ui\Tab
     */
    public function addUiTab()
    {
        return $this->items[] = new Ui\Tab();
    }

    /**
     * @return string
     * @throws \Exception
     */
    public function __toString()
    {
        $class = get_class($this);

        do {
            $class_name = self::compileNameClass($class);

            if ($path_view = \Theme::findView(\Theme::getCurrentTheme(), $class_name)) {
                return (new Render($path_view, [
                    'view' => $this
                ]))->display();
            }
        } while ($class !== 'ui' && $class = get_parent_class($class));

        throw new \Exception(sprintf('Нет шаблона для отображения модели %s', $class_name));
    }
}